\name{run.intvl.task}
\alias{run.intvl.task}
\title{ Run Interval Task }
\description{
  Carry out time block/interval analysis
}
\usage{
run.intvl.task(settings)
}
\arguments{
  \item{settings}{}
}
\value{
}
\details{
}
\author{Jin Cao \url{cao@bell-labs.com},
        William S. Cleveland \url{wsc@bell-labs.com},
	Don X. Sun \url{dxsun@bell-labs.com}
        \url{http://cm.bell-labs.com/stat/InternetTraffic/S-Net}
}
\seealso{
}
\examples{
## packet analysis
objLst _ drop.names(unlist(ols("tcppac.anony.2000.03.08.*m30.35")))[1:2]; objLst
subObjLst _ subset.object(objLst, var="dir")
task.subset.samp.df _ get.intvl.df(subObjLst, type="pac",
                                     TIMESTAMP.OPTION = "pac.end",
                                     pacSize.type = "ETH.PAYLOAD",
                                     LINKSPEED = 10^8)
osave("BLMar08.2intvl.pac.subset.samp.df", task.subset.samp.df)
settings _
  list(taskid = "BLMar08.2intvl",
       subtask = "pac.ia.marg",
       fitting.type = "p2",
       pac.ia.transform = "standardized.one.sixth.power",
       STREAMVAR = c('ip0','port0','ip1','port1','dir'),
       timeunit = 0.1,
       pac.cnt.transform = "standardized",
       )
settings$subtask = "pac" 
run.intvl.task(settings);

## flow analysis
objLst _ drop.names(unlist(ols("flow.anony.2000.03.08.*m30.35")))[1:2]; objLst
task.subset.samp.df _ get.intvl.df(objLst, type="flow")
osave("BLMar08.2intvl.flow.subset.samp.df", task.subset.samp.df)
settings _
  list(taskid = "BLMar08.2intvl",
       subtask = "flow",
       fitting.type = "p2")
run.intvl.task(settings);
}
\keyword{dplot}

