\name{spectrum.plot}
\alias{spectrum.plot}
\title{ Spectrum Plot }
\description{
  Spectrum Plot
}
\usage{
spectrum.plot(fit, label=list(), psfile="", append=F,
                         xscale="original", type="fit", horizontal=F,
                         ...)
}
\arguments{
  \item{fit}{ the fitted object from fit.fsd.log10spec.unbiased(). }
  \item{label}{ an optinal list for supplying user-defined \code{xlab},
    \code{ylab}, \code{main}, \code{sub}, \code{labels} }
  \item{psfile}{ file name for saving plot to a postscript file }
  \item{append, horizontal}{ arguments to the \code{trellis.device} fucntion. }
  \item{xscale}{ \code{original} or \code{sqrt} }
  \item{type}{ \code{fit}, \code{geweke.residual},  or \code{fit.residual} }
  \item{\dots}{ other arguments passed on to \code{qqmath}. }
}
\value{
  An object of class trellis, by default plotted by \code{print.trellis}.
}
\details{
  This is a customized plot using the generic plot function \code{qqmath}.
}
\author{Jin Cao \email{cao@bell-labs.com},
        William S. Cleveland \email{wsc@bell-labs.com},
	Don X. Sun \email{dxsun@bell-labs.com},
        \url{http://cm.bell-labs.com/stat/InternetTraffic/S-Net}
}
\seealso{
  \code{\link{time.plot}},
  \code{\link{unif.qqplot}},
  \code{\link{weibull.qqplot}},
  \code{\link{normal.qqplot}},
  \code{\link{pareto.qqplot}},
  \code{\link{spectrum.plot}},
  \code{\link{fit.fsd.log10spec.unbiased}}
}
\examples{
objNm _ "My Data"
x _ rnorm(1000) + sin(seq(1000)/50*pi); plot(x, type="l")
if(exists("fracdiff.sim")) {
  d <- 0.25; x <- fracdiff.sim(n=1000, ar=0, ma=-1, d=d)$series
}
fit _ fit.log10spec.unbiased(x, type="p2")
spectrum.plot(fit, label=list(main=objNm))
spectrum.plot(fit, xscal="sqrt", label=list(main=objNm))
spectrum.plot(fit, label=list(main=objNm), psfile="demo.ps")
spectrum.plot(fit, xscale="original", label=list(main=objNm), psfile="demo.ps")
spectrum.plot(fit, label=list(main=objNm), type="geweke.residual", psfile="demo.ps")
spectrum.plot(fit, label=list(main=objNm), type="fit.residual", psfile="demo.ps")
}
\keyword{dplot}

