\name{time.plot}
\alias{time.plot}
\title{ Time Plot }
\description{
  Plot a variable in time
}
\usage{
time.plot(x, y, label=list(), psfile="", append=F, horizontal=F, ...)
}
\arguments{
  \item{x}{ the variable representing time. }
  \item{y}{ the variable to be plotted in time. }
  \item{label}{ an optinal list for supplying user-defined \code{xlab},
    \code{ylab}, \code{main}, \code{sub}, \code{labels} }
  \item{psfile}{ file name for saving plot to a postscript file }
  \item{append}{ arguments to the \code{trellis.device} function. }
  \item{horizontal}{ arguments to the \code{trellis.device} function. }
  \item{\dots}{Other arguments passed on to \code{xyplot}}
}
\value{
  An object of class trellis, by default plotted by \code{print.trellis}.
}
\details{
  This is a customized plot using the generic plot function \code{xyplot}.
}
\author{Jin Cao \url{cao@bell-labs.com},
        William S. Cleveland \url{wsc@bell-labs.com},
	Don X. Sun \url{dxsun@bell-labs.com},
        \url{http://cm.bell-labs.com/stat/InternetTraffic/S-Net}
}
\seealso{\code{\link{weibull.qqplot}}, \code{\link{unif.qqplot}},
  \code{\link{spectrum.plot}}, \code{\link{normal.qqplot}},
  \code{\link{pareto.qqplot}}
}
\examples{
fsize = abs(rnorm(1000)); time = sort(runif(1000))
time.plot(time, fsize)
time.plot(time, fsize, label=list(main="My Time Plot",
                                  sub=list(label="My Sub-Title", col="red")))
time.plot(time, fsize, label=list(main="My Time Plot",
                                  sub=list(label="My Sub-Title", col="red")),
          psfile="demo.ps")
}
\keyword{dplot}

