\name{weibull.qqplot}
\alias{weibull.qqplot}
\title{ Weibull Q-Q Plot }
\description{
  Quantile-Quantile plot of a sample and a theoretical Weibull distribution
}
\usage{
weibull.qqplot(y, cond, label=list(), psfile="", append=F, estimate=list(), horizontal=F, ...)
}
\arguments{
  \item{y}{ the variable to be plotted. }
  \item{cond}{ optional conditioning variable. }
  \item{label}{ an optinal list for supplying user-defined \code{xlab},
    \code{ylab}, \code{main}, \code{sub}, \code{labels} }
  \item{estimate}{ is a list(shape, scale, type), where type is "ME" or "MLE",
    as output from weibull.estimate(x, type="ME") or weibull.estimate(x, type="MLE")
 }
  \item{psfile}{ file name for saving plot to a postscript file }
  \item{append}{ arguments to the \code{trellis.device} function. }
  \item{horizontal}{ arguments to the \code{trellis.device} function. }
  \item{\dots}{Other arguments passed on to \code{qqmath}}
}
\value{
  An object of class trellis, by default plotted by \code{print.trellis}.
}
\details{
  This is a customized plot using the generic plot function \code{qqmath}.
}
\author{Jin Cao \email{cao@bell-labs.com},
        William S. Cleveland \email{wsc@bell-labs.com},
	Don X. Sun \email{dxsun@bell-labs.com},
        \url{http://cm.bell-labs.com/stat/InternetTraffic/S-Net}
}
\seealso{\code{\link{time.plot}},
  \code{\link{unif.qqplot}},
  \code{\link{spectrum.plot}},
  \code{\link{normal.qqplot}},
  \code{\link{pareto.qqplot}},
  \code{\link{weibull.ME}},
  \code{\link{weibull.MLE}},
}
\examples{
y _ rexp(1000)^(1/.7)
type _ paste(rep(c("A","B"),length(y)/2))
mle _ weibull.MLE(y)
weibull.qqplot(y)
weibull.qqplot(y, cond=type)
weibull.qqplot(y, cond=type, label=list(main="weibull.qqplot"), estimate=mle)
weibull.qqplot(y, cond=type, label=list( main="weibull.qqplot"), estimate=mle),
               psfile="demo.ps")
}
\keyword{dplot}

