### $Id: classDefs.q,v 1.3 2001/09/24 21:36:16 pinheiro Exp $
###
###                 oldClass definitions for S-Plus 5
###
### Copyright 1998-1999  Jose C. Pinheiro <jcp@research.bell-labs.com>,
###                      Douglas M. Bates <bates@stat.wisc.edu>
###                      Saikat DebRoy    <saikat@stat.wisc.edu>
###
### This file is part of the nlme library for S and related languages.
### It is made available under the terms of the GNU General Public
### License, version 2, or at your option, any later version,
### incorporated herein by reference.
### 
### This program is distributed in the hope that it will be
### useful, but WITHOUT ANY WARRANTY; without even the implied
### warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
### PURPOSE.  See the GNU General Public License for more
### details.
### 
### You should have received a copy of the GNU General Public
### License along with this program; if not, write to the Free
### Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
### MA 02111-1307, USA

## lme classes
setOldClass("lme")
setOldClass(c("anova.lme", "data.frame"))
setOldClass("intervals.lme")
setOldClass(c("ranef.lme", "data.frame"))
setOldClass(c("coef.lme", "ranef.lme", "data.frame"))
setOldClass(c("summary.lme", "lme"))
setOldClass(c("lmeStruct", "modelStruct"))
setOldClass(c("lmeStructInt","lmeStruct", "modelStruct"))
setOldClass("simulate.lme")
setOldClass("VarCorr.lme")

## lmList classes
setOldClass("lmList")
setOldClass("intervals.lmList")
setOldClass(c("ranef.lmList", "data.frame"))
setOldClass(c("coef.lmList", "ranef.lmList", "data.frame"))
setOldClass("summary.lmList")

## gls classes
setOldClass("gls")
setOldClass("intervals.gls")
setOldClass(c("summary.gls", "gls"))
setOldClass(c("glsStruct", "modelStruct"))

## nlme classes
setOldClass(c("nlme","lme"))
setOldClass(c("nlmeStruct", "lmeStruct", "modelStruct"))
setOldClass(c("nlmeStructInt", "nlmeStruct", "lmeStruct", "modelStruct"))

## nlsList classes
setOldClass(c("nlsList", "lmList"))
setOldClass(c("summary.nlsList", "summary.lmList"))

## gnls classes
setOldClass(c("gnls", "gls"))
setOldClass(c("gnlsStruct", "glsStruct", "modelStruct"))

## corStruct classes
setOldClass(c("corSymm", "corStruct"))
setOldClass(c("corSymmNat", "corStruct"))
setOldClass(c("corBand", "corStruct"))
setOldClass(c("corBandNat", "corStruct"))
setOldClass(c("corAR1", "corStruct"))
setOldClass(c("corAR1Nat", "corStruct"))
setOldClass(c("corARMA", "corStruct"))
setOldClass(c("corARMANat", "corStruct"))
setOldClass(c("corCAR1", "corStruct"))
setOldClass(c("corCAR1Nat", "corStruct"))
setOldClass(c("corCompSymm", "corStruct"))
setOldClass(c("corCompSymmNat", "corStruct"))
setOldClass(c("corIdent", "corStruct"))
setOldClass(c("corExp", "corSpatial", "corStruct"))
setOldClass(c("corGaus", "corSpatial", "corStruct"))
setOldClass(c("corLin", "corSpatial", "corStruct"))
setOldClass(c("corLinNat", "corSpatialNat", "corStruct"))
setOldClass(c("corRatio", "corSpatial", "corStruct"))
setOldClass(c("corSpher", "corSpatial", "corStruct"))
setOldClass(c("corSpherNat", "corSpatialNat", "corStruct"))
setOldClass(c("corSpatialNat", "corStruct"))
setOldClass(c("corStrat", "corStruct"))
setOldClass("summary.corStruct")
setOldClass("summary.corSymm")

## pdMat classes
setOldClass(c("pdSymm", "pdMat"))
setOldClass(c("pdSymmNat", "pdMat"))
setOldClass(c("pdDiag", "pdMat"))
setOldClass(c("pdDiagNat", "pdMat"))
setOldClass(c("pdIdent", "pdMat"))
setOldClass(c("pdIdentNat", "pdMat"))
setOldClass(c("pdCompSymm", "pdMat"))
setOldClass(c("pdCompSymmNat", "pdMat"))
setOldClass(c("pdBand", "pdMat"))
setOldClass(c("pdBandNat", "pdMat"))
setOldClass(c("pdBlocked", "pdMat"))
setOldClass(c("pdKron", "pdMat"))
setOldClass(c("pdStrat", "pdMat"))
setOldClass("summary.pdMat")
setOldClass("summary.pdKron")
setOldClass("summary.pdStrat")

## varFunc classes
setOldClass(c("varFixed", "varFunc"))
setOldClass(c("varIdent", "varFunc"))
setOldClass(c("varIdentNat", "varFunc"))
setOldClass(c("varPower", "varFunc"))
setOldClass(c("varExp", "varFunc"))
setOldClass(c("varConstPower", "varFunc"))
setOldClass(c("varConstPowerNat", "varFunc"))
setOldClass(c("varComb", "varFunc"))
setOldClass("summary.varFunc")
setOldClass("summary.varFixed")
setOldClass("summary.varComb")

## groupedData classes
setOldClass(c("groupedData", "data.frame"))
setOldClass(c("nffGroupedData", "nfGroupedData", "groupedData", "data.frame"))
setOldClass(c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"))
setOldClass(c("nmGroupedData", "groupedData", "data.frame"))

## miscellaneous classes
setOldClass(c("ACF", "data.frame"))
setOldClass(c("augPred", "data.frame"))
setOldClass(c("comparePred", "augPred", "data.frame"))
setOldClass("compareFits")
setOldClass("correlation")
setOldClass("logLik")
setOldClass("listof")
setOldClass("listForm")
setOldClass("reStruct")
setOldClass("selfStart")
setOldClass(c("sortedXyData", "data.frame"))
setOldClass(c("Variogram", "data.frame"))

## Plot method was misbehaving with unnamed second arguments.
## Fix below suggested by John Chambers 

setDefaultMethod("plot",
### the default method for plot.  If there is an old-style method for
### the class of `x', this is called, to be consistent with previous
### method matching, which ignored the second argument.
###
### Otherwise, `xycall' and the C-level graphics code are used.
function(x, y, ...)
{
  cl <- oldClass(x)
  if(!(is.null(cl) || identical( oldMethod("plot", cl), "plot.default")))
    UseMethod("plot")
  else {
    xyCall(x, y, function(x, y, xlab, ylab, ...)
           .Internal(plot("zplot", x = x, y = y,
                          xlab = xlab, ylab = ylab, ...),
                     "call_S_Version2"),
           xexpr = substitute(x), yexpr = substitute(y), ...)
  }
}
)


### Local variables:
### mode: S
### End:
