### Name: Oracle
### Title: Instantiate an Oracle client from the current R session
### Aliases: Oracle
### Keywords: interface database

### ** Examples
## Not run: 
##D ## create a Oracle instance and create one connection.
##D ora <- Oracle()     ## or dbDriver("Oracle")
##D con <- dbConnect(ora, user = "opto", password="pure-light", db="oras")
##D 
##D ## you can also use Oracle's user/password@dbname convention
##D con2 <- dbConnect(ora, user = "opto/pure-light@oras")
##D 
##D ## or if you have defined the ORACLE_SID shell variable
##D con3 <- dbConnect(ora, user = "opto", password = "pure-light")
##D 
##D ## clone an existing connection
##D w <- dbConnect(con)
##D 
##D ## execute a statement and fetch its output in chunks of no more
##D ## than 5000 rows at a time
##D 
##D rs <- dbSendQuery(con, "select * from HTTP_ACCESS where IP_ADDRESS='127.0.0.1'")
##D 
##D while(!dbHasCompleted(rs)){
##D    df <- fetch(rs, n = 5000)
##D    process(df)
##D }
##D dbHasCompleted(rs)
##D [1] TRUE
##D dbClearResult(rs)      ## done with this query
##D [1] TRUE
##D 
##D ## prepare and bind columns 2, 3, and 7 to the Oracle table 
##D ## fields "cell", "erlangs", "blocking"
##D ps <- dbPrepareStatement(con, 
##D          "INSERT into my_table (cell, erlangs, blocking) VALUE (:2,:3,:7)",
##D          bind = my.data.frame)
##D 
##D ## execute one sql INSERT per row using columns 2, 3 and 7 
##D ps <- dbExecStatement(ps, my.data.frame)
##D ps <- dbExecStatement(ps, more.data)
##D 
##D dbCommit(con)  ## ok, everything looks fine
##D 
##D ## a concise description of the driver 
##D summary(ora)
##D 
##D <OraDriver:(24694)> 
##D   Driver name:  Oracle (ProC/C++) 
##D   Max  connections: 10 
##D   Conn. processed: 9 
##D   Default records per fetch: 500 
##D   Open connections: 2 
##D 
##D ## a full description of the ora connection
##D summary(con, verbose = T)
##D 
##D <OraConnection:(25272,0)> 
##D   User: opto 
##D   Dbname: oras 
##D   Oracle Server version: 
##D     Oracle8 Enterprise Edition Release 8.0.4.0.0 - Production 
##D     PL/SQL Release 8.0.4.0.0 - Production 
##D     CORE Version 4.0.4.0.0 - Production 
##D     TNS for Solaris: Version 8.0.4.0.0 - Production 
##D     NLSRTL Version 3.3.1.0.0 - Production 
##D 
##D dbDisconnect(con)     ## done with this connection
##D [1] TRUE
## End(Not run)



