### Name: dbConnect-methods
### Title: Create a connection object to an Oracle DBMS
### Aliases: dbDisconnect-methods dbConnect-methods
###   dbDisconnect,OraConnection-method dbConnect,OraDriver-method
###   dbConnect,OraConnection-method dbConnect,character-method
### Keywords: methods interface database

### ** Examples
## Not run: 
##D # create an Oracle instance and create one connection.
##D drv <- dbDriver("Oracle")
##D 
##D # open the connection using user, passsword, etc., as
##D con <- dbConnect(drv, "user/password@dbname")
##D 
##D # Run an SQL statement by creating first a resultSet object
##D rs <- dbSendQuery(con, statement = paste(
##D                       "SELECT w.laser_id, w.wavelength, p.cut_off",
##D                       "FROM WL w, PURGE P", 
##D                       "WHERE w.laser_id = p.laser_id", 
##D                       "SORT BY w.laser_id")
##D # we now fetch records from the resultSet into a data.frame
##D data <- fetch(rs, n = -1)   # extract all rows
##D dim(data)
## End(Not run)



