### Name: dbGetInfo-methods
### Title: Database interface meta-data
### Aliases: dbGetInfo dbGetDBIVersion-methods dbGetStatement-methods
###   dbGetRowCount-methods dbGetRowsAffected-methods dbColumnInfo-methods
###   dbHasCompleted-methods dbGetInfo,OraObject-method
###   dbGetInfo,OraDriver-method dbGetInfo,OraConnection-method
###   dbGetInfo,OraResult-method dbGetInfo,OraPreparedStatement-method
###   dbGetStatement,OraResult-method dbGetRowCount,OraResult-method
###   dbGetRowsAffected,OraResult-method dbColumnInfo,OraResult-method
###   dbHasCompleted,OraResult-method
### Keywords: methods interface database

### ** Examples
## Not run: 
##D drv <- dbDriver("Oracle")
##D con <- dbConnect(drv, "user/passwd@dbname")
##D 
##D dbListTables(con)
##D 
##D rs <- dbSendQuery(con, query.sql)
##D dbGetStatement(rs)
##D dbHasCompleted(rs)
##D 
##D info <- dbGetInfo(rs)
##D names(dbGetInfo(drv))  
##D 
##D # DBIConnection info
##D names(dbGetInfo(con))
##D 
##D # DBIResult info
##D names(dbGetInfo(rs)) 
## End(Not run)



