### Name: dbPrepareStatement-methods
### Title: Create a prepared SQL statement for repeated execution
### Aliases: dbPrepareStatement dbPrepareStatement-methods
###   dbPrepareStatement,OraConnection,character,character-method
###   dbPrepareStatement,OraConnection,character,data.frame-method
###   dbExecStatement dbExecStatement-methods
###   dbExecStatement,OraPreparedStatement,data.frame-method
### Keywords: database interface classes methods

### ** Examples
## Not run: 
##D   con <- dbConnect("Oracle", "user/password")
##D 
##D   ps <- dbPrepareStatement(con, 
##D            "INSERT into QUAKES (lat, long1, mag) VALUES (:1, :2, :4)",
##D            bind = c("numeric", "numeric", "numeric"))
##D 
##D   dbExecStatement(ps, data = quakes)
##D   dbExecStatement(ps, data = more.quakes)
##D   ...
##D   dbExecStatement(ps, data = yet.more.quakes)
##D 
##D   ## how many rows have we (tentatively) inserted?
##D   summary(ps)
##D 
##D   ## everything looks fine, so let's commit and wrap up
##D   dbCommit(con)
##D   dbClearResult(ps)
## End(Not run)



