### Name: dbConnect-methods
### Title: Create a connection object to an SQLite DBMS
### Aliases: dbDisconnect-methods dbConnect-methods
###   dbDisconnect,SQLiteConnection-method dbConnect,SQLiteDriver-method
###   dbConnect,SQLiteConnection-method dbConnect,character-method
### Keywords: interface interface database

### ** Examples
## Not run: 
##D # create an SQLite instance and create one connection.
##D drv <- dbDriver("SQLite")
##D 
##D # open the connection using user, passsword, etc., as
##D con <- dbConnect(drv, dbname = "sqlite.db")
##D 
##D # Run an SQL statement by creating first a resultSet object
##D rs <- dbSendQuery(con, statement = paste(
##D                       "SELECT w.laser_id, w.wavelength, p.cut_off",
##D                       "FROM WL w, PURGE P", 
##D                       "WHERE w.laser_id = p.laser_id", 
##D                       "SORT BY w.laser_id")
##D # we now fetch records from the resultSet into a data.frame
##D data <- fetch(rs, n = -1)   # extract all rows
##D dim(data)
## End(Not run)



