###  $Id: tests,v 1.2 1998/10/21 13:11:16 pinheiro Exp $

detach("nlme3")
library(nlme3, lib.loc="../..", first=T)
#options(conflicts.ok = T)

if (!exists("testfit")) testfit <-
  function(object, tolerance = .Machine$double.eps^0.5)
  {
    fit <- object$origCall
    if (is.null(fit))
      fit <- object$call
    if(is.null(fit))
      fit <- attr(object, "call")
    if(!is.language(fit))
      stop("object must have the fitting expression as component \"call\"")
    print(fit)
    nframe <- FALSE
    newfit <- eval(fit, nframe)
    all.equal(object, newfit, tolerance)
  }

## Orthodont
rm.Orth <- F
if (!exists("Orth.lis")) {
  data.restore("Orth.tst")
  rm.Orth <- T
}
testfit(Orth.lis)
testfit(Orth.lme1)
testfit(Orth.lme2)
testfit(Orth.lme3)
testfit(Orth.lme4)
testfit(Orth.gls)
all.equal(Orth.pred, predict(Orth.lme3, newOrth))
if(rm.Orth) {
  rm(Orth.lis)
  rm(Orth.lme1)
  rm(Orth.lme2)
  rm(Orth.lme3)
  rm(Orth.lme4)
  rm(Orth.gls)
  rm(Orth.pred)
  rm(newOrth)
}

## Ovary
rm.ovary <- F
if (!exists("Ovary.lis")) {
  data.restore("Ovary.tst")
  rm.ovary <- T
}
testfit(Ovary.lis)
testfit(Ovary.lme1)
testfit(Ovary.lme2)
testfit(Ovary.lme3)
testfit(Ovary.gls)
if(rm.ovary) {
  rm(Ovary.lis)
  rm(Ovary.lme1)
  rm(Ovary.lme2)
  rm(Ovary.lme3)
  rm(Ovary.gls)
}


## Pixel
rm.Pix <- F
if (!exists("Pix.lis")) {
  data.restore("Pix.tst")
  rm.Pix <- T
}
testfit(Pix.lis)
testfit(Pix.lme1)
testfit(Pix.lme2)
all.equal(Pix.pred, predict(Pix.lme1, newPix, level=0:2))
if(rm.Pix) {
  rm(Pix.lis)
  rm(Pix.lme1)
  rm(Pix.lme2)
  rm(Pix.pred)
  rm(newPix)
}

#Theoph
rm.Theo <- F
if (!exists("Theo.lis")) {
 data.restore("Theo.tst")
 rm.Theo <- T
}
testfit(Theo.lis)
testfit(Theo.nlme1)
testfit(Theo.nlme2)
testfit(Theo.nlme3)
testfit(Theo.nlme4)
testfit(Theo.gnls)
if(rm.Theo) {
 rm(Theo.lis)
 rm(Theo.nlme1)
 rm(Theo.nlme2)
 rm(Theo.nlme3)
 rm(Theo.nlme4)
 rm(Theo.gnls)
}


# Local Variables:
# mode:S
# End:
