### $Id: Glucose2.q,v 1.1 1999/08/24 20:39:05 pinheiro Exp $
### Data on the glucose levels of several subjects over time after
###  ingestion of alcohol
### Hand and Crowder (1996), Table A.17, p. 180-181.

"Glucose2"<-
  structure(list(
   Subject = structure(factor(c(1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7), levels = 1:7), 
     class = "factor",
     .Label = c("1", "2", "3", "4", "5", "6", "7")),
    Date = structure(factor(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2),
        levels = 1:2),
        class = "factor",
	.Label = c("1", "2")),
    Time = c(-1, 0, 2, 
	4, 6, 8, 10, 12, 15, 18, 21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 
	10, 12, 15, 18, 21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 
	15, 18, 21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 
	21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 
	27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 27, 30, 
	-1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 27, 30, -1, 0, 2, 
	4, 6, 8, 10, 12, 15, 18, 21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 
	10, 12, 15, 18, 21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 
	15, 18, 21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 
	21, 24, 27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 
	27, 30, -1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 27, 30, 
	-1, 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 27, 30),
    glucose = c(3, 3, 4.7000000000000002, 6, 6.2999999999999998, 
	4.2999999999999998, 3, 2, 4.5, 3.7999999999999998, 
	3.2000000000000002, 2.6000000000000001, 2.6000000000000001, 
	2.6000000000000001, 4, 3.6000000000000001, 6, 
	8.5999999999999996, 8.8000000000000007, 7.2000000000000002, 
	5, 3.7999999999999998, 4.2000000000000002, 4, 
	2.6000000000000001, 2.5, 2.6000000000000001, 
	3.7999999999999998, 3.5, 3.5, 6, 7.2999999999999998, 7.5, 
	6.2000000000000002, 5, 4.0999999999999996, 
	4.2999999999999998, 4.0999999999999996, 3.3999999999999999, 
	3.7999999999999998, 3.7999999999999998, 3.8999999999999999, 
	3.7999999999999998, 3.7999999999999998, 4.4000000000000004, 
	6, 6.7999999999999998, 5.7000000000000002, 
	4.5999999999999996, 3.7999999999999998, 4.2999999999999998, 
	4.5, 4.5, 4.2000000000000002, 3.7999999999999998, 
	4.2000000000000002, 3.7000000000000002, 4, 
	5.2000000000000002, 7, 6.5999999999999996, 6, 
	5.2000000000000002, 4.7000000000000002, 4.5, 4.5, 
	4.2000000000000002, 3.5, 3.7000000000000002, 
	3.7999999999999998, 3.5, 3.1000000000000001, 
	3.1000000000000001, 3.6000000000000001, 4.2000000000000002, 
	3.7999999999999998, 3.5, 4.2000000000000002, 
	3.7000000000000002, 4.0999999999999996, 3.2000000000000002, 
	3.3999999999999999, 3.3999999999999999, 3.2000000000000002, 
	3, 2.8999999999999999, 5, 6.2000000000000002, 
	7.7000000000000002, 5.9000000000000004, 3.8999999999999999, 
	5.7999999999999998, 5, 5.2000000000000002, 
	4.2999999999999998, 4, 3.5, 3.5, 2.2000000000000002, 
	2.7999999999999998, 4.4000000000000004, 5.5999999999999996, 
	5.7999999999999998, 4.5, 3.6000000000000001, 
	3.2999999999999998, 3.2000000000000002, 3.2999999999999998, 
	3, 3, 3.2000000000000002, 3.1000000000000001, 
	4.0999999999999996, 4.2000000000000002, 6.2999999999999998, 
	7, 8.3000000000000007, 5.7000000000000002, 
	2.8999999999999999, 3, 3.3999999999999999, 3.5, 
	3.2000000000000002, 3.7999999999999998, 4.2999999999999998, 
	3.7000000000000002, 3.7999999999999998, 3.7999999999999998, 
	5, 5.5, 7, 5, 3.7999999999999998, 3.6000000000000001, 
	3.6000000000000001, 3.5, 3.5, 3.5, 3.5, 4, 
	3.6000000000000001, 3.6000000000000001, 4.2999999999999998, 
	5.5, 6.2999999999999998, 5.7000000000000002, 
	5.2999999999999998, 4.7000000000000002, 4, 3.5, 
	3.6000000000000001, 3.7000000000000002, 4, 
	3.7000000000000002, 3.7999999999999998, 3.7999999999999998, 
	4.7000000000000002, 7, 7.7000000000000002, 6, 5, 
	4.7000000000000002, 4.2999999999999998, 4.2000000000000002, 
	3.7000000000000002, 3.3999999999999999, 3.7000000000000002, 
	3.7999999999999998, 3.6000000000000001, 3.5, 
	4.4000000000000004, 6.2000000000000002, 7, 
	5.9000000000000004, 4.7999999999999998, 3.8999999999999999, 
	3.8999999999999999, 4, 3.7000000000000002, 3.5, 
	3.7999999999999998, 3.7999999999999998, 3.2999999999999998, 
	2.8999999999999999, 4.2000000000000002, 5.7999999999999998, 
	5.7999999999999998, 5.7999999999999998, 4.4000000000000004, 
	4, 3.7999999999999998, 3.7000000000000002, 
	3.3999999999999999, 3.6000000000000001, 3.6000000000000001, 
	3.6000000000000001)),
row.names = as.character(1:196),
class = c("nmGroupedData", "groupedData", "data.frame"),
formula = glucose ~ Time | Subject/Date,
formulaList = list(Subject = ~ Subject, Date = ~ Date),
labels = list(x = "Time since alcohol ingestion", y = "Blood glucose level"),
units = list(x = "(min/10)", y = "(mg/dl)"),
order.groups = list(Subject = T, Date = F),
FUN = function(x) max(x, na.rm = TRUE))
