S> ### $Id: Multilocation.St,v 1.1 1998/04/10 23:04:01 bates Exp $
S> ### Analysis of the Multilocation data with fixed effects for the locations
S> options( contrasts = c(factor = "contr.SAS", ordered = "contr.poly") )
S> formula( Multilocation )
Adj ~ 1 | Location/Block
S> names( Multilocation )
[1] "obs"      "Location" "Block"    "Trt"      "Adj"     
[6] "Fe"       "Grp"     
S> ### Create a Block %in% Location factor
S> Multilocation$Grp <-
+   getGroups( Multilocation, form = ~ Location/Block, level = 2 )
S> fm1Mult <- lme( Adj ~ Location * Trt, data = Multilocation, ~ 1 | Grp )
S> summary( fm1Mult )
Linear mixed-effects model fit by maximum likelihood
 Data: Multilocation 
      AIC    BIC logLik 
  -11.142 90.779 43.571

Random effects:
 Formula:  ~ 1 | Grp
        (Intercept) Residual 
StdDev:    0.061212  0.15183

Fixed effects:  Adj ~ Location * Trt 
                  Value Std.Error z-value p-value 
     (Intercept)  2.866     0.032  90.958   0.000
      Location.L  0.814     0.095   8.608   0.000
      Location.Q  0.244     0.095   2.582   0.010
      Location.C  0.099     0.095   1.048   0.295
    Location ^ 4 -0.300     0.095  -3.170   0.002
    Location ^ 5  0.127     0.095   1.346   0.178
    Location ^ 6 -0.033     0.095  -0.350   0.727
    Location ^ 7 -0.408     0.095  -4.317   0.000
    Location ^ 8  0.085     0.095   0.901   0.368
            Trt1  0.058     0.041   1.412   0.158
            Trt2 -0.188     0.041  -4.550   0.000
            Trt3  0.084     0.041   2.028   0.043
  Location.LTrt1  0.200     0.124   1.615   0.106
  Location.QTrt1 -0.303     0.124  -2.448   0.014
  Location.CTrt1 -0.041     0.124  -0.330   0.741
Location ^ 4Trt1  0.364     0.124   2.936   0.003
Location ^ 5Trt1 -0.148     0.124  -1.194   0.233
Location ^ 6Trt1  0.025     0.124   0.199   0.842
Location ^ 7Trt1  0.147     0.124   1.185   0.236
Location ^ 8Trt1  0.197     0.124   1.588   0.112
  Location.LTrt2  0.081     0.124   0.655   0.512
  Location.QTrt2 -0.324     0.124  -2.611   0.009
  Location.CTrt2 -0.138     0.124  -1.111   0.267
Location ^ 4Trt2  0.071     0.124   0.576   0.565
Location ^ 5Trt2  0.040     0.124   0.319   0.749
Location ^ 6Trt2  0.112     0.124   0.907   0.365
Location ^ 7Trt2  0.237     0.124   1.908   0.056
Location ^ 8Trt2 -0.038     0.124  -0.303   0.762
  Location.LTrt3  0.134     0.124   1.084   0.278
  Location.QTrt3 -0.338     0.124  -2.730   0.006
  Location.CTrt3  0.097     0.124   0.782   0.434
Location ^ 4Trt3  0.109     0.124   0.882   0.378
Location ^ 5Trt3 -0.137     0.124  -1.106   0.269
Location ^ 6Trt3  0.184     0.124   1.481   0.139
Location ^ 7Trt3  0.280     0.124   2.258   0.024
Location ^ 8Trt3 -0.006     0.124  -0.047   0.963
 Correlation: 
                 (Intercept) Location.L Location.Q Location.C 
      Location.L  0.00000                                    
      Location.Q  0.00000     0.00000                        
      Location.C  0.00000     0.00000    0.00000             
    Location ^ 4  0.00000     0.00000    0.00000    0.00000  
    Location ^ 5  0.00000     0.00000    0.00000    0.00000  
    Location ^ 6  0.00000     0.00000    0.00000    0.00000  
    Location ^ 7  0.00000     0.00000    0.00000    0.00000  
    Location ^ 8  0.00000     0.00000    0.00000    0.00000  
            Trt1 -0.65582     0.00000    0.00000    0.00000  
            Trt2 -0.65582     0.00000    0.00000    0.00000  
            Trt3 -0.65582     0.00000    0.00000    0.00000  
  Location.LTrt1  0.00000    -0.65582    0.00000    0.00000  
  Location.QTrt1  0.00000     0.00000   -0.65582    0.00000  
  Location.CTrt1  0.00000     0.00000    0.00000   -0.65582  
Location ^ 4Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 5Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 6Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 7Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 8Trt1  0.00000     0.00000    0.00000    0.00000  
  Location.LTrt2  0.00000    -0.65582    0.00000    0.00000  
  Location.QTrt2  0.00000     0.00000   -0.65582    0.00000  
  Location.CTrt2  0.00000     0.00000    0.00000   -0.65582  
Location ^ 4Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 5Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 6Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 7Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 8Trt2  0.00000     0.00000    0.00000    0.00000  
  Location.LTrt3  0.00000    -0.65582    0.00000    0.00000  
  Location.QTrt3  0.00000     0.00000   -0.65582    0.00000  
  Location.CTrt3  0.00000     0.00000    0.00000   -0.65582  
Location ^ 4Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 5Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 6Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 7Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 8Trt3  0.00000     0.00000    0.00000    0.00000  
                 Location ^ 4 Location ^ 5 Location ^ 6 
      Location.L                                       
      Location.Q                                       
      Location.C                                       
    Location ^ 4                                       
    Location ^ 5  0.00000                              
    Location ^ 6  0.00000      0.00000                 
    Location ^ 7  0.00000      0.00000      0.00000    
    Location ^ 8  0.00000      0.00000      0.00000    
            Trt1  0.00000      0.00000      0.00000    
            Trt2  0.00000      0.00000      0.00000    
            Trt3  0.00000      0.00000      0.00000    
  Location.LTrt1  0.00000      0.00000      0.00000    
  Location.QTrt1  0.00000      0.00000      0.00000    
  Location.CTrt1  0.00000      0.00000      0.00000    
Location ^ 4Trt1 -0.65582      0.00000      0.00000    
Location ^ 5Trt1  0.00000     -0.65582      0.00000    
Location ^ 6Trt1  0.00000      0.00000     -0.65582    
Location ^ 7Trt1  0.00000      0.00000      0.00000    
Location ^ 8Trt1  0.00000      0.00000      0.00000    
  Location.LTrt2  0.00000      0.00000      0.00000    
  Location.QTrt2  0.00000      0.00000      0.00000    
  Location.CTrt2  0.00000      0.00000      0.00000    
Location ^ 4Trt2 -0.65582      0.00000      0.00000    
Location ^ 5Trt2  0.00000     -0.65582      0.00000    
Location ^ 6Trt2  0.00000      0.00000     -0.65582    
Location ^ 7Trt2  0.00000      0.00000      0.00000    
Location ^ 8Trt2  0.00000      0.00000      0.00000    
  Location.LTrt3  0.00000      0.00000      0.00000    
  Location.QTrt3  0.00000      0.00000      0.00000    
  Location.CTrt3  0.00000      0.00000      0.00000    
Location ^ 4Trt3 -0.65582      0.00000      0.00000    
Location ^ 5Trt3  0.00000     -0.65582      0.00000    
Location ^ 6Trt3  0.00000      0.00000     -0.65582    
Location ^ 7Trt3  0.00000      0.00000      0.00000    
Location ^ 8Trt3  0.00000      0.00000      0.00000    
                 Location ^ 7 Location ^ 8     Trt1     Trt2 
      Location.L                                            
      Location.Q                                            
      Location.C                                            
    Location ^ 4                                            
    Location ^ 5                                            
    Location ^ 6                                            
    Location ^ 7                                            
    Location ^ 8  0.00000                                   
            Trt1  0.00000      0.00000                      
            Trt2  0.00000      0.00000      0.50000         
            Trt3  0.00000      0.00000      0.50000  0.50000
  Location.LTrt1  0.00000      0.00000      0.00000  0.00000
  Location.QTrt1  0.00000      0.00000      0.00000  0.00000
  Location.CTrt1  0.00000      0.00000      0.00000  0.00000
Location ^ 4Trt1  0.00000      0.00000      0.00000  0.00000
Location ^ 5Trt1  0.00000      0.00000      0.00000  0.00000
Location ^ 6Trt1  0.00000      0.00000      0.00000  0.00000
Location ^ 7Trt1 -0.65582      0.00000      0.00000  0.00000
Location ^ 8Trt1  0.00000     -0.65582      0.00000  0.00000
  Location.LTrt2  0.00000      0.00000      0.00000  0.00000
  Location.QTrt2  0.00000      0.00000      0.00000  0.00000
  Location.CTrt2  0.00000      0.00000      0.00000  0.00000
Location ^ 4Trt2  0.00000      0.00000      0.00000  0.00000
Location ^ 5Trt2  0.00000      0.00000      0.00000  0.00000
Location ^ 6Trt2  0.00000      0.00000      0.00000  0.00000
Location ^ 7Trt2 -0.65582      0.00000      0.00000  0.00000
Location ^ 8Trt2  0.00000     -0.65582      0.00000  0.00000
  Location.LTrt3  0.00000      0.00000      0.00000  0.00000
  Location.QTrt3  0.00000      0.00000      0.00000  0.00000
  Location.CTrt3  0.00000      0.00000      0.00000  0.00000
Location ^ 4Trt3  0.00000      0.00000      0.00000  0.00000
Location ^ 5Trt3  0.00000      0.00000      0.00000  0.00000
Location ^ 6Trt3  0.00000      0.00000      0.00000  0.00000
Location ^ 7Trt3 -0.65582      0.00000      0.00000  0.00000
Location ^ 8Trt3  0.00000     -0.65582      0.00000  0.00000
                     Trt3 Location.LTrt1 Location.QTrt1 
      Location.L                                       
      Location.Q                                       
      Location.C                                       
    Location ^ 4                                       
    Location ^ 5                                       
    Location ^ 6                                       
    Location ^ 7                                       
    Location ^ 8                                       
            Trt1                                       
            Trt2                                       
            Trt3                                       
  Location.LTrt1  0.00000                              
  Location.QTrt1  0.00000  0.00000                     
  Location.CTrt1  0.00000  0.00000        0.00000      
Location ^ 4Trt1  0.00000  0.00000        0.00000      
Location ^ 5Trt1  0.00000  0.00000        0.00000      
Location ^ 6Trt1  0.00000  0.00000        0.00000      
Location ^ 7Trt1  0.00000  0.00000        0.00000      
Location ^ 8Trt1  0.00000  0.00000        0.00000      
  Location.LTrt2  0.00000  0.50000        0.00000      
  Location.QTrt2  0.00000  0.00000        0.50000      
  Location.CTrt2  0.00000  0.00000        0.00000      
Location ^ 4Trt2  0.00000  0.00000        0.00000      
Location ^ 5Trt2  0.00000  0.00000        0.00000      
Location ^ 6Trt2  0.00000  0.00000        0.00000      
Location ^ 7Trt2  0.00000  0.00000        0.00000      
Location ^ 8Trt2  0.00000  0.00000        0.00000      
  Location.LTrt3  0.00000  0.50000        0.00000      
  Location.QTrt3  0.00000  0.00000        0.50000      
  Location.CTrt3  0.00000  0.00000        0.00000      
Location ^ 4Trt3  0.00000  0.00000        0.00000      
Location ^ 5Trt3  0.00000  0.00000        0.00000      
Location ^ 6Trt3  0.00000  0.00000        0.00000      
Location ^ 7Trt3  0.00000  0.00000        0.00000      
Location ^ 8Trt3  0.00000  0.00000        0.00000      
                 Location.CTrt1 Location ^ 4Trt1 
      Location.L                                
      Location.Q                                
      Location.C                                
    Location ^ 4                                
    Location ^ 5                                
    Location ^ 6                                
    Location ^ 7                                
    Location ^ 8                                
            Trt1                                
            Trt2                                
            Trt3                                
  Location.LTrt1                                
  Location.QTrt1                                
  Location.CTrt1                                
Location ^ 4Trt1  0.00000                       
Location ^ 5Trt1  0.00000        0.00000        
Location ^ 6Trt1  0.00000        0.00000        
Location ^ 7Trt1  0.00000        0.00000        
Location ^ 8Trt1  0.00000        0.00000        
  Location.LTrt2  0.00000        0.00000        
  Location.QTrt2  0.00000        0.00000        
  Location.CTrt2  0.50000        0.00000        
Location ^ 4Trt2  0.00000        0.50000        
Location ^ 5Trt2  0.00000        0.00000        
Location ^ 6Trt2  0.00000        0.00000        
Location ^ 7Trt2  0.00000        0.00000        
Location ^ 8Trt2  0.00000        0.00000        
  Location.LTrt3  0.00000        0.00000        
  Location.QTrt3  0.00000        0.00000        
  Location.CTrt3  0.50000        0.00000        
Location ^ 4Trt3  0.00000        0.50000        
Location ^ 5Trt3  0.00000        0.00000        
Location ^ 6Trt3  0.00000        0.00000        
Location ^ 7Trt3  0.00000        0.00000        
Location ^ 8Trt3  0.00000        0.00000        
                 Location ^ 5Trt1 Location ^ 6Trt1 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1  0.00000                         
Location ^ 7Trt1  0.00000          0.00000        
Location ^ 8Trt1  0.00000          0.00000        
  Location.LTrt2  0.00000          0.00000        
  Location.QTrt2  0.00000          0.00000        
  Location.CTrt2  0.00000          0.00000        
Location ^ 4Trt2  0.00000          0.00000        
Location ^ 5Trt2  0.50000          0.00000        
Location ^ 6Trt2  0.00000          0.50000        
Location ^ 7Trt2  0.00000          0.00000        
Location ^ 8Trt2  0.00000          0.00000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.00000          0.00000        
Location ^ 5Trt3  0.50000          0.00000        
Location ^ 6Trt3  0.00000          0.50000        
Location ^ 7Trt3  0.00000          0.00000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 7Trt1 Location ^ 8Trt1 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1  0.00000                         
  Location.LTrt2  0.00000          0.00000        
  Location.QTrt2  0.00000          0.00000        
  Location.CTrt2  0.00000          0.00000        
Location ^ 4Trt2  0.00000          0.00000        
Location ^ 5Trt2  0.00000          0.00000        
Location ^ 6Trt2  0.00000          0.00000        
Location ^ 7Trt2  0.50000          0.00000        
Location ^ 8Trt2  0.00000          0.50000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.00000          0.00000        
Location ^ 5Trt3  0.00000          0.00000        
Location ^ 6Trt3  0.00000          0.00000        
Location ^ 7Trt3  0.50000          0.00000        
Location ^ 8Trt3  0.00000          0.50000        
                 Location.LTrt2 Location.QTrt2 Location.CTrt2 
      Location.L                                             
      Location.Q                                             
      Location.C                                             
    Location ^ 4                                             
    Location ^ 5                                             
    Location ^ 6                                             
    Location ^ 7                                             
    Location ^ 8                                             
            Trt1                                             
            Trt2                                             
            Trt3                                             
  Location.LTrt1                                             
  Location.QTrt1                                             
  Location.CTrt1                                             
Location ^ 4Trt1                                             
Location ^ 5Trt1                                             
Location ^ 6Trt1                                             
Location ^ 7Trt1                                             
Location ^ 8Trt1                                             
  Location.LTrt2                                             
  Location.QTrt2  0.00000                                    
  Location.CTrt2  0.00000        0.00000                     
Location ^ 4Trt2  0.00000        0.00000        0.00000      
Location ^ 5Trt2  0.00000        0.00000        0.00000      
Location ^ 6Trt2  0.00000        0.00000        0.00000      
Location ^ 7Trt2  0.00000        0.00000        0.00000      
Location ^ 8Trt2  0.00000        0.00000        0.00000      
  Location.LTrt3  0.50000        0.00000        0.00000      
  Location.QTrt3  0.00000        0.50000        0.00000      
  Location.CTrt3  0.00000        0.00000        0.50000      
Location ^ 4Trt3  0.00000        0.00000        0.00000      
Location ^ 5Trt3  0.00000        0.00000        0.00000      
Location ^ 6Trt3  0.00000        0.00000        0.00000      
Location ^ 7Trt3  0.00000        0.00000        0.00000      
Location ^ 8Trt3  0.00000        0.00000        0.00000      
                 Location ^ 4Trt2 Location ^ 5Trt2 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1                                  
  Location.LTrt2                                  
  Location.QTrt2                                  
  Location.CTrt2                                  
Location ^ 4Trt2                                  
Location ^ 5Trt2  0.00000                         
Location ^ 6Trt2  0.00000          0.00000        
Location ^ 7Trt2  0.00000          0.00000        
Location ^ 8Trt2  0.00000          0.00000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.50000          0.00000        
Location ^ 5Trt3  0.00000          0.50000        
Location ^ 6Trt3  0.00000          0.00000        
Location ^ 7Trt3  0.00000          0.00000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 6Trt2 Location ^ 7Trt2 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1                                  
  Location.LTrt2                                  
  Location.QTrt2                                  
  Location.CTrt2                                  
Location ^ 4Trt2                                  
Location ^ 5Trt2                                  
Location ^ 6Trt2                                  
Location ^ 7Trt2  0.00000                         
Location ^ 8Trt2  0.00000          0.00000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.00000          0.00000        
Location ^ 5Trt3  0.00000          0.00000        
Location ^ 6Trt3  0.50000          0.00000        
Location ^ 7Trt3  0.00000          0.50000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 8Trt2 Location.LTrt3 Location.QTrt3 
      Location.L                                               
      Location.Q                                               
      Location.C                                               
    Location ^ 4                                               
    Location ^ 5                                               
    Location ^ 6                                               
    Location ^ 7                                               
    Location ^ 8                                               
            Trt1                                               
            Trt2                                               
            Trt3                                               
  Location.LTrt1                                               
  Location.QTrt1                                               
  Location.CTrt1                                               
Location ^ 4Trt1                                               
Location ^ 5Trt1                                               
Location ^ 6Trt1                                               
Location ^ 7Trt1                                               
Location ^ 8Trt1                                               
  Location.LTrt2                                               
  Location.QTrt2                                               
  Location.CTrt2                                               
Location ^ 4Trt2                                               
Location ^ 5Trt2                                               
Location ^ 6Trt2                                               
Location ^ 7Trt2                                               
Location ^ 8Trt2                                               
  Location.LTrt3  0.00000                                      
  Location.QTrt3  0.00000          0.00000                     
  Location.CTrt3  0.00000          0.00000        0.00000      
Location ^ 4Trt3  0.00000          0.00000        0.00000      
Location ^ 5Trt3  0.00000          0.00000        0.00000      
Location ^ 6Trt3  0.00000          0.00000        0.00000      
Location ^ 7Trt3  0.00000          0.00000        0.00000      
Location ^ 8Trt3  0.50000          0.00000        0.00000      
                 Location.CTrt3 Location ^ 4Trt3 
      Location.L                                
      Location.Q                                
      Location.C                                
    Location ^ 4                                
    Location ^ 5                                
    Location ^ 6                                
    Location ^ 7                                
    Location ^ 8                                
            Trt1                                
            Trt2                                
            Trt3                                
  Location.LTrt1                                
  Location.QTrt1                                
  Location.CTrt1                                
Location ^ 4Trt1                                
Location ^ 5Trt1                                
Location ^ 6Trt1                                
Location ^ 7Trt1                                
Location ^ 8Trt1                                
  Location.LTrt2                                
  Location.QTrt2                                
  Location.CTrt2                                
Location ^ 4Trt2                                
Location ^ 5Trt2                                
Location ^ 6Trt2                                
Location ^ 7Trt2                                
Location ^ 8Trt2                                
  Location.LTrt3                                
  Location.QTrt3                                
  Location.CTrt3                                
Location ^ 4Trt3  0.00000                       
Location ^ 5Trt3  0.00000        0.00000        
Location ^ 6Trt3  0.00000        0.00000        
Location ^ 7Trt3  0.00000        0.00000        
Location ^ 8Trt3  0.00000        0.00000        
                 Location ^ 5Trt3 Location ^ 6Trt3 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1                                  
  Location.LTrt2                                  
  Location.QTrt2                                  
  Location.CTrt2                                  
Location ^ 4Trt2                                  
Location ^ 5Trt2                                  
Location ^ 6Trt2                                  
Location ^ 7Trt2                                  
Location ^ 8Trt2                                  
  Location.LTrt3                                  
  Location.QTrt3                                  
  Location.CTrt3                                  
Location ^ 4Trt3                                  
Location ^ 5Trt3                                  
Location ^ 6Trt3  0.00000                         
Location ^ 7Trt3  0.00000          0.00000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 7Trt3 
      Location.L                 
      Location.Q                 
      Location.C                 
    Location ^ 4                 
    Location ^ 5                 
    Location ^ 6                 
    Location ^ 7                 
    Location ^ 8                 
            Trt1                 
            Trt2                 
            Trt3                 
  Location.LTrt1                 
  Location.QTrt1                 
  Location.CTrt1                 
Location ^ 4Trt1                 
Location ^ 5Trt1                 
Location ^ 6Trt1                 
Location ^ 7Trt1                 
Location ^ 8Trt1                 
  Location.LTrt2                 
  Location.QTrt2                 
  Location.CTrt2                 
Location ^ 4Trt2                 
Location ^ 5Trt2                 
Location ^ 6Trt2                 
Location ^ 7Trt2                 
Location ^ 8Trt2                 
  Location.LTrt3                 
  Location.QTrt3                 
  Location.CTrt3                 
Location ^ 4Trt3                 
Location ^ 5Trt3                 
Location ^ 6Trt3                 
Location ^ 7Trt3                 
Location ^ 8Trt3  0.00000        

Standardized Within-Group Residuals:
     Min      Q1         Med      Q3   Max 
 -2.4871 -0.5169 -0.00095886 0.55418 3.297

Number of Observations: 108
Number of Groups: 27 
S> options( digits = 5 )
S> summary( fm1Mult )
Linear mixed-effects model fit by maximum likelihood
 Data: Multilocation 
      AIC    BIC logLik 
  -11.142 90.779 43.571

Random effects:
 Formula:  ~ 1 | Grp
        (Intercept) Residual 
StdDev:    0.061212  0.15183

Fixed effects:  Adj ~ Location * Trt 
                  Value Std.Error z-value p-value 
     (Intercept)  2.866     0.032  90.958   0.000
      Location.L  0.814     0.095   8.608   0.000
      Location.Q  0.244     0.095   2.582   0.010
      Location.C  0.099     0.095   1.048   0.295
    Location ^ 4 -0.300     0.095  -3.170   0.002
    Location ^ 5  0.127     0.095   1.346   0.178
    Location ^ 6 -0.033     0.095  -0.350   0.727
    Location ^ 7 -0.408     0.095  -4.317   0.000
    Location ^ 8  0.085     0.095   0.901   0.368
            Trt1  0.058     0.041   1.412   0.158
            Trt2 -0.188     0.041  -4.550   0.000
            Trt3  0.084     0.041   2.028   0.043
  Location.LTrt1  0.200     0.124   1.615   0.106
  Location.QTrt1 -0.303     0.124  -2.448   0.014
  Location.CTrt1 -0.041     0.124  -0.330   0.741
Location ^ 4Trt1  0.364     0.124   2.936   0.003
Location ^ 5Trt1 -0.148     0.124  -1.194   0.233
Location ^ 6Trt1  0.025     0.124   0.199   0.842
Location ^ 7Trt1  0.147     0.124   1.185   0.236
Location ^ 8Trt1  0.197     0.124   1.588   0.112
  Location.LTrt2  0.081     0.124   0.655   0.512
  Location.QTrt2 -0.324     0.124  -2.611   0.009
  Location.CTrt2 -0.138     0.124  -1.111   0.267
Location ^ 4Trt2  0.071     0.124   0.576   0.565
Location ^ 5Trt2  0.040     0.124   0.319   0.749
Location ^ 6Trt2  0.112     0.124   0.907   0.365
Location ^ 7Trt2  0.237     0.124   1.908   0.056
Location ^ 8Trt2 -0.038     0.124  -0.303   0.762
  Location.LTrt3  0.134     0.124   1.084   0.278
  Location.QTrt3 -0.338     0.124  -2.730   0.006
  Location.CTrt3  0.097     0.124   0.782   0.434
Location ^ 4Trt3  0.109     0.124   0.882   0.378
Location ^ 5Trt3 -0.137     0.124  -1.106   0.269
Location ^ 6Trt3  0.184     0.124   1.481   0.139
Location ^ 7Trt3  0.280     0.124   2.258   0.024
Location ^ 8Trt3 -0.006     0.124  -0.047   0.963
 Correlation: 
                 (Intercept) Location.L Location.Q Location.C 
      Location.L  0.00000                                    
      Location.Q  0.00000     0.00000                        
      Location.C  0.00000     0.00000    0.00000             
    Location ^ 4  0.00000     0.00000    0.00000    0.00000  
    Location ^ 5  0.00000     0.00000    0.00000    0.00000  
    Location ^ 6  0.00000     0.00000    0.00000    0.00000  
    Location ^ 7  0.00000     0.00000    0.00000    0.00000  
    Location ^ 8  0.00000     0.00000    0.00000    0.00000  
            Trt1 -0.65582     0.00000    0.00000    0.00000  
            Trt2 -0.65582     0.00000    0.00000    0.00000  
            Trt3 -0.65582     0.00000    0.00000    0.00000  
  Location.LTrt1  0.00000    -0.65582    0.00000    0.00000  
  Location.QTrt1  0.00000     0.00000   -0.65582    0.00000  
  Location.CTrt1  0.00000     0.00000    0.00000   -0.65582  
Location ^ 4Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 5Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 6Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 7Trt1  0.00000     0.00000    0.00000    0.00000  
Location ^ 8Trt1  0.00000     0.00000    0.00000    0.00000  
  Location.LTrt2  0.00000    -0.65582    0.00000    0.00000  
  Location.QTrt2  0.00000     0.00000   -0.65582    0.00000  
  Location.CTrt2  0.00000     0.00000    0.00000   -0.65582  
Location ^ 4Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 5Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 6Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 7Trt2  0.00000     0.00000    0.00000    0.00000  
Location ^ 8Trt2  0.00000     0.00000    0.00000    0.00000  
  Location.LTrt3  0.00000    -0.65582    0.00000    0.00000  
  Location.QTrt3  0.00000     0.00000   -0.65582    0.00000  
  Location.CTrt3  0.00000     0.00000    0.00000   -0.65582  
Location ^ 4Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 5Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 6Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 7Trt3  0.00000     0.00000    0.00000    0.00000  
Location ^ 8Trt3  0.00000     0.00000    0.00000    0.00000  
                 Location ^ 4 Location ^ 5 Location ^ 6 
      Location.L                                       
      Location.Q                                       
      Location.C                                       
    Location ^ 4                                       
    Location ^ 5  0.00000                              
    Location ^ 6  0.00000      0.00000                 
    Location ^ 7  0.00000      0.00000      0.00000    
    Location ^ 8  0.00000      0.00000      0.00000    
            Trt1  0.00000      0.00000      0.00000    
            Trt2  0.00000      0.00000      0.00000    
            Trt3  0.00000      0.00000      0.00000    
  Location.LTrt1  0.00000      0.00000      0.00000    
  Location.QTrt1  0.00000      0.00000      0.00000    
  Location.CTrt1  0.00000      0.00000      0.00000    
Location ^ 4Trt1 -0.65582      0.00000      0.00000    
Location ^ 5Trt1  0.00000     -0.65582      0.00000    
Location ^ 6Trt1  0.00000      0.00000     -0.65582    
Location ^ 7Trt1  0.00000      0.00000      0.00000    
Location ^ 8Trt1  0.00000      0.00000      0.00000    
  Location.LTrt2  0.00000      0.00000      0.00000    
  Location.QTrt2  0.00000      0.00000      0.00000    
  Location.CTrt2  0.00000      0.00000      0.00000    
Location ^ 4Trt2 -0.65582      0.00000      0.00000    
Location ^ 5Trt2  0.00000     -0.65582      0.00000    
Location ^ 6Trt2  0.00000      0.00000     -0.65582    
Location ^ 7Trt2  0.00000      0.00000      0.00000    
Location ^ 8Trt2  0.00000      0.00000      0.00000    
  Location.LTrt3  0.00000      0.00000      0.00000    
  Location.QTrt3  0.00000      0.00000      0.00000    
  Location.CTrt3  0.00000      0.00000      0.00000    
Location ^ 4Trt3 -0.65582      0.00000      0.00000    
Location ^ 5Trt3  0.00000     -0.65582      0.00000    
Location ^ 6Trt3  0.00000      0.00000     -0.65582    
Location ^ 7Trt3  0.00000      0.00000      0.00000    
Location ^ 8Trt3  0.00000      0.00000      0.00000    
                 Location ^ 7 Location ^ 8     Trt1     Trt2 
      Location.L                                            
      Location.Q                                            
      Location.C                                            
    Location ^ 4                                            
    Location ^ 5                                            
    Location ^ 6                                            
    Location ^ 7                                            
    Location ^ 8  0.00000                                   
            Trt1  0.00000      0.00000                      
            Trt2  0.00000      0.00000      0.50000         
            Trt3  0.00000      0.00000      0.50000  0.50000
  Location.LTrt1  0.00000      0.00000      0.00000  0.00000
  Location.QTrt1  0.00000      0.00000      0.00000  0.00000
  Location.CTrt1  0.00000      0.00000      0.00000  0.00000
Location ^ 4Trt1  0.00000      0.00000      0.00000  0.00000
Location ^ 5Trt1  0.00000      0.00000      0.00000  0.00000
Location ^ 6Trt1  0.00000      0.00000      0.00000  0.00000
Location ^ 7Trt1 -0.65582      0.00000      0.00000  0.00000
Location ^ 8Trt1  0.00000     -0.65582      0.00000  0.00000
  Location.LTrt2  0.00000      0.00000      0.00000  0.00000
  Location.QTrt2  0.00000      0.00000      0.00000  0.00000
  Location.CTrt2  0.00000      0.00000      0.00000  0.00000
Location ^ 4Trt2  0.00000      0.00000      0.00000  0.00000
Location ^ 5Trt2  0.00000      0.00000      0.00000  0.00000
Location ^ 6Trt2  0.00000      0.00000      0.00000  0.00000
Location ^ 7Trt2 -0.65582      0.00000      0.00000  0.00000
Location ^ 8Trt2  0.00000     -0.65582      0.00000  0.00000
  Location.LTrt3  0.00000      0.00000      0.00000  0.00000
  Location.QTrt3  0.00000      0.00000      0.00000  0.00000
  Location.CTrt3  0.00000      0.00000      0.00000  0.00000
Location ^ 4Trt3  0.00000      0.00000      0.00000  0.00000
Location ^ 5Trt3  0.00000      0.00000      0.00000  0.00000
Location ^ 6Trt3  0.00000      0.00000      0.00000  0.00000
Location ^ 7Trt3 -0.65582      0.00000      0.00000  0.00000
Location ^ 8Trt3  0.00000     -0.65582      0.00000  0.00000
                     Trt3 Location.LTrt1 Location.QTrt1 
      Location.L                                       
      Location.Q                                       
      Location.C                                       
    Location ^ 4                                       
    Location ^ 5                                       
    Location ^ 6                                       
    Location ^ 7                                       
    Location ^ 8                                       
            Trt1                                       
            Trt2                                       
            Trt3                                       
  Location.LTrt1  0.00000                              
  Location.QTrt1  0.00000  0.00000                     
  Location.CTrt1  0.00000  0.00000        0.00000      
Location ^ 4Trt1  0.00000  0.00000        0.00000      
Location ^ 5Trt1  0.00000  0.00000        0.00000      
Location ^ 6Trt1  0.00000  0.00000        0.00000      
Location ^ 7Trt1  0.00000  0.00000        0.00000      
Location ^ 8Trt1  0.00000  0.00000        0.00000      
  Location.LTrt2  0.00000  0.50000        0.00000      
  Location.QTrt2  0.00000  0.00000        0.50000      
  Location.CTrt2  0.00000  0.00000        0.00000      
Location ^ 4Trt2  0.00000  0.00000        0.00000      
Location ^ 5Trt2  0.00000  0.00000        0.00000      
Location ^ 6Trt2  0.00000  0.00000        0.00000      
Location ^ 7Trt2  0.00000  0.00000        0.00000      
Location ^ 8Trt2  0.00000  0.00000        0.00000      
  Location.LTrt3  0.00000  0.50000        0.00000      
  Location.QTrt3  0.00000  0.00000        0.50000      
  Location.CTrt3  0.00000  0.00000        0.00000      
Location ^ 4Trt3  0.00000  0.00000        0.00000      
Location ^ 5Trt3  0.00000  0.00000        0.00000      
Location ^ 6Trt3  0.00000  0.00000        0.00000      
Location ^ 7Trt3  0.00000  0.00000        0.00000      
Location ^ 8Trt3  0.00000  0.00000        0.00000      
                 Location.CTrt1 Location ^ 4Trt1 
      Location.L                                
      Location.Q                                
      Location.C                                
    Location ^ 4                                
    Location ^ 5                                
    Location ^ 6                                
    Location ^ 7                                
    Location ^ 8                                
            Trt1                                
            Trt2                                
            Trt3                                
  Location.LTrt1                                
  Location.QTrt1                                
  Location.CTrt1                                
Location ^ 4Trt1  0.00000                       
Location ^ 5Trt1  0.00000        0.00000        
Location ^ 6Trt1  0.00000        0.00000        
Location ^ 7Trt1  0.00000        0.00000        
Location ^ 8Trt1  0.00000        0.00000        
  Location.LTrt2  0.00000        0.00000        
  Location.QTrt2  0.00000        0.00000        
  Location.CTrt2  0.50000        0.00000        
Location ^ 4Trt2  0.00000        0.50000        
Location ^ 5Trt2  0.00000        0.00000        
Location ^ 6Trt2  0.00000        0.00000        
Location ^ 7Trt2  0.00000        0.00000        
Location ^ 8Trt2  0.00000        0.00000        
  Location.LTrt3  0.00000        0.00000        
  Location.QTrt3  0.00000        0.00000        
  Location.CTrt3  0.50000        0.00000        
Location ^ 4Trt3  0.00000        0.50000        
Location ^ 5Trt3  0.00000        0.00000        
Location ^ 6Trt3  0.00000        0.00000        
Location ^ 7Trt3  0.00000        0.00000        
Location ^ 8Trt3  0.00000        0.00000        
                 Location ^ 5Trt1 Location ^ 6Trt1 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1  0.00000                         
Location ^ 7Trt1  0.00000          0.00000        
Location ^ 8Trt1  0.00000          0.00000        
  Location.LTrt2  0.00000          0.00000        
  Location.QTrt2  0.00000          0.00000        
  Location.CTrt2  0.00000          0.00000        
Location ^ 4Trt2  0.00000          0.00000        
Location ^ 5Trt2  0.50000          0.00000        
Location ^ 6Trt2  0.00000          0.50000        
Location ^ 7Trt2  0.00000          0.00000        
Location ^ 8Trt2  0.00000          0.00000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.00000          0.00000        
Location ^ 5Trt3  0.50000          0.00000        
Location ^ 6Trt3  0.00000          0.50000        
Location ^ 7Trt3  0.00000          0.00000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 7Trt1 Location ^ 8Trt1 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1  0.00000                         
  Location.LTrt2  0.00000          0.00000        
  Location.QTrt2  0.00000          0.00000        
  Location.CTrt2  0.00000          0.00000        
Location ^ 4Trt2  0.00000          0.00000        
Location ^ 5Trt2  0.00000          0.00000        
Location ^ 6Trt2  0.00000          0.00000        
Location ^ 7Trt2  0.50000          0.00000        
Location ^ 8Trt2  0.00000          0.50000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.00000          0.00000        
Location ^ 5Trt3  0.00000          0.00000        
Location ^ 6Trt3  0.00000          0.00000        
Location ^ 7Trt3  0.50000          0.00000        
Location ^ 8Trt3  0.00000          0.50000        
                 Location.LTrt2 Location.QTrt2 Location.CTrt2 
      Location.L                                             
      Location.Q                                             
      Location.C                                             
    Location ^ 4                                             
    Location ^ 5                                             
    Location ^ 6                                             
    Location ^ 7                                             
    Location ^ 8                                             
            Trt1                                             
            Trt2                                             
            Trt3                                             
  Location.LTrt1                                             
  Location.QTrt1                                             
  Location.CTrt1                                             
Location ^ 4Trt1                                             
Location ^ 5Trt1                                             
Location ^ 6Trt1                                             
Location ^ 7Trt1                                             
Location ^ 8Trt1                                             
  Location.LTrt2                                             
  Location.QTrt2  0.00000                                    
  Location.CTrt2  0.00000        0.00000                     
Location ^ 4Trt2  0.00000        0.00000        0.00000      
Location ^ 5Trt2  0.00000        0.00000        0.00000      
Location ^ 6Trt2  0.00000        0.00000        0.00000      
Location ^ 7Trt2  0.00000        0.00000        0.00000      
Location ^ 8Trt2  0.00000        0.00000        0.00000      
  Location.LTrt3  0.50000        0.00000        0.00000      
  Location.QTrt3  0.00000        0.50000        0.00000      
  Location.CTrt3  0.00000        0.00000        0.50000      
Location ^ 4Trt3  0.00000        0.00000        0.00000      
Location ^ 5Trt3  0.00000        0.00000        0.00000      
Location ^ 6Trt3  0.00000        0.00000        0.00000      
Location ^ 7Trt3  0.00000        0.00000        0.00000      
Location ^ 8Trt3  0.00000        0.00000        0.00000      
                 Location ^ 4Trt2 Location ^ 5Trt2 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1                                  
  Location.LTrt2                                  
  Location.QTrt2                                  
  Location.CTrt2                                  
Location ^ 4Trt2                                  
Location ^ 5Trt2  0.00000                         
Location ^ 6Trt2  0.00000          0.00000        
Location ^ 7Trt2  0.00000          0.00000        
Location ^ 8Trt2  0.00000          0.00000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.50000          0.00000        
Location ^ 5Trt3  0.00000          0.50000        
Location ^ 6Trt3  0.00000          0.00000        
Location ^ 7Trt3  0.00000          0.00000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 6Trt2 Location ^ 7Trt2 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1                                  
  Location.LTrt2                                  
  Location.QTrt2                                  
  Location.CTrt2                                  
Location ^ 4Trt2                                  
Location ^ 5Trt2                                  
Location ^ 6Trt2                                  
Location ^ 7Trt2  0.00000                         
Location ^ 8Trt2  0.00000          0.00000        
  Location.LTrt3  0.00000          0.00000        
  Location.QTrt3  0.00000          0.00000        
  Location.CTrt3  0.00000          0.00000        
Location ^ 4Trt3  0.00000          0.00000        
Location ^ 5Trt3  0.00000          0.00000        
Location ^ 6Trt3  0.50000          0.00000        
Location ^ 7Trt3  0.00000          0.50000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 8Trt2 Location.LTrt3 Location.QTrt3 
      Location.L                                               
      Location.Q                                               
      Location.C                                               
    Location ^ 4                                               
    Location ^ 5                                               
    Location ^ 6                                               
    Location ^ 7                                               
    Location ^ 8                                               
            Trt1                                               
            Trt2                                               
            Trt3                                               
  Location.LTrt1                                               
  Location.QTrt1                                               
  Location.CTrt1                                               
Location ^ 4Trt1                                               
Location ^ 5Trt1                                               
Location ^ 6Trt1                                               
Location ^ 7Trt1                                               
Location ^ 8Trt1                                               
  Location.LTrt2                                               
  Location.QTrt2                                               
  Location.CTrt2                                               
Location ^ 4Trt2                                               
Location ^ 5Trt2                                               
Location ^ 6Trt2                                               
Location ^ 7Trt2                                               
Location ^ 8Trt2                                               
  Location.LTrt3  0.00000                                      
  Location.QTrt3  0.00000          0.00000                     
  Location.CTrt3  0.00000          0.00000        0.00000      
Location ^ 4Trt3  0.00000          0.00000        0.00000      
Location ^ 5Trt3  0.00000          0.00000        0.00000      
Location ^ 6Trt3  0.00000          0.00000        0.00000      
Location ^ 7Trt3  0.00000          0.00000        0.00000      
Location ^ 8Trt3  0.50000          0.00000        0.00000      
                 Location.CTrt3 Location ^ 4Trt3 
      Location.L                                
      Location.Q                                
      Location.C                                
    Location ^ 4                                
    Location ^ 5                                
    Location ^ 6                                
    Location ^ 7                                
    Location ^ 8                                
            Trt1                                
            Trt2                                
            Trt3                                
  Location.LTrt1                                
  Location.QTrt1                                
  Location.CTrt1                                
Location ^ 4Trt1                                
Location ^ 5Trt1                                
Location ^ 6Trt1                                
Location ^ 7Trt1                                
Location ^ 8Trt1                                
  Location.LTrt2                                
  Location.QTrt2                                
  Location.CTrt2                                
Location ^ 4Trt2                                
Location ^ 5Trt2                                
Location ^ 6Trt2                                
Location ^ 7Trt2                                
Location ^ 8Trt2                                
  Location.LTrt3                                
  Location.QTrt3                                
  Location.CTrt3                                
Location ^ 4Trt3  0.00000                       
Location ^ 5Trt3  0.00000        0.00000        
Location ^ 6Trt3  0.00000        0.00000        
Location ^ 7Trt3  0.00000        0.00000        
Location ^ 8Trt3  0.00000        0.00000        
                 Location ^ 5Trt3 Location ^ 6Trt3 
      Location.L                                  
      Location.Q                                  
      Location.C                                  
    Location ^ 4                                  
    Location ^ 5                                  
    Location ^ 6                                  
    Location ^ 7                                  
    Location ^ 8                                  
            Trt1                                  
            Trt2                                  
            Trt3                                  
  Location.LTrt1                                  
  Location.QTrt1                                  
  Location.CTrt1                                  
Location ^ 4Trt1                                  
Location ^ 5Trt1                                  
Location ^ 6Trt1                                  
Location ^ 7Trt1                                  
Location ^ 8Trt1                                  
  Location.LTrt2                                  
  Location.QTrt2                                  
  Location.CTrt2                                  
Location ^ 4Trt2                                  
Location ^ 5Trt2                                  
Location ^ 6Trt2                                  
Location ^ 7Trt2                                  
Location ^ 8Trt2                                  
  Location.LTrt3                                  
  Location.QTrt3                                  
  Location.CTrt3                                  
Location ^ 4Trt3                                  
Location ^ 5Trt3                                  
Location ^ 6Trt3  0.00000                         
Location ^ 7Trt3  0.00000          0.00000        
Location ^ 8Trt3  0.00000          0.00000        
                 Location ^ 7Trt3 
      Location.L                 
      Location.Q                 
      Location.C                 
    Location ^ 4                 
    Location ^ 5                 
    Location ^ 6                 
    Location ^ 7                 
    Location ^ 8                 
            Trt1                 
            Trt2                 
            Trt3                 
  Location.LTrt1                 
  Location.QTrt1                 
  Location.CTrt1                 
Location ^ 4Trt1                 
Location ^ 5Trt1                 
Location ^ 6Trt1                 
Location ^ 7Trt1                 
Location ^ 8Trt1                 
  Location.LTrt2                 
  Location.QTrt2                 
  Location.CTrt2                 
Location ^ 4Trt2                 
Location ^ 5Trt2                 
Location ^ 6Trt2                 
Location ^ 7Trt2                 
Location ^ 8Trt2                 
  Location.LTrt3                 
  Location.QTrt3                 
  Location.CTrt3                 
Location ^ 4Trt3                 
Location ^ 5Trt3                 
Location ^ 6Trt3                 
Location ^ 7Trt3                 
Location ^ 8Trt3  0.00000        

Standardized Within-Group Residuals:
     Min      Q1         Med      Q3   Max 
 -2.4871 -0.5169 -0.00095886 0.55418 3.297

Number of Observations: 108
Number of Groups: 27 
S> fm2Mult <- update( fm1Mult, Adj ~ Location + Trt )
S> fm3Mult <- update( fm1Mult, Adj ~ Location )
S> fm4Mult <- update( fm1Mult, Adj ~ Trt )
S> fm5Mult <- update( fm1Mult, Adj ~ 1 )
S> anova( fm1Mult, fm2Mult, fm3Mult, fm5Mult )
        Model df     AIC    BIC  logLik Test Lik.Ratio  p-value 
fm1Mult     1 38 -11.142 90.779  43.571                        
fm2Mult     2 14 -24.501 13.049  26.250         34.641 0.073907
fm3Mult     3 11  -0.954 28.550  11.477         29.547 0.000002
fm5Mult     4  3  49.731 57.778 -21.866         66.685 0.000000
S> anova( fm1Mult, fm2Mult, fm4Mult, fm5Mult )
        Model df     AIC    BIC  logLik Test Lik.Ratio  p-value 
fm1Mult     1 38 -11.142 90.779  43.571                        
fm2Mult     2 14 -24.501 13.049  26.250         34.641 0.073907
fm4Mult     3  6  26.952 43.045  -7.476         67.453 0.000000
fm5Mult     4  3  49.731 57.778 -21.866         28.780 0.000002
S> ### AIC, BIC, and likelihood ratio tests all prefer model fm2Mult
S> summary( fm2Mult )
Linear mixed-effects model fit by maximum likelihood
 Data: Multilocation 
      AIC    BIC logLik 
  -24.501 13.049  26.25

Random effects:
 Formula:  ~ 1 | Grp
        (Intercept) Residual 
StdDev:    0.025912  0.18803

Fixed effects:  Adj ~ Location + Trt 
              Value Std.Error z-value p-value 
 (Intercept)  2.866     0.037  78.450   0.000
  Location.L  0.918     0.056  16.297   0.000
  Location.Q  0.003     0.056   0.046   0.963
  Location.C  0.079     0.056   1.396   0.163
Location ^ 4 -0.163     0.056  -2.903   0.004
Location ^ 5  0.066     0.056   1.169   0.242
Location ^ 6  0.047     0.056   0.836   0.403
Location ^ 7 -0.242     0.056  -4.301   0.000
Location ^ 8  0.123     0.056   2.193   0.028
        Trt1  0.058     0.051   1.140   0.254
        Trt2 -0.188     0.051  -3.674   0.000
        Trt3  0.084     0.051   1.637   0.102
 Correlation: 
             (Intercept) Location.L Location.Q Location.C 
  Location.L  0.00000                                    
  Location.Q  0.00000     0.00000                        
  Location.C  0.00000     0.00000    0.00000             
Location ^ 4  0.00000     0.00000    0.00000    0.00000  
Location ^ 5  0.00000     0.00000    0.00000    0.00000  
Location ^ 6  0.00000     0.00000    0.00000    0.00000  
Location ^ 7  0.00000     0.00000    0.00000    0.00000  
Location ^ 8  0.00000     0.00000    0.00000    0.00000  
        Trt1 -0.70049     0.00000    0.00000    0.00000  
        Trt2 -0.70049     0.00000    0.00000    0.00000  
        Trt3 -0.70049     0.00000    0.00000    0.00000  
             Location ^ 4 Location ^ 5 Location ^ 6 
  Location.L                                       
  Location.Q                                       
  Location.C                                       
Location ^ 4                                       
Location ^ 5  0.00000                              
Location ^ 6  0.00000      0.00000                 
Location ^ 7  0.00000      0.00000      0.00000    
Location ^ 8  0.00000      0.00000      0.00000    
        Trt1  0.00000      0.00000      0.00000    
        Trt2  0.00000      0.00000      0.00000    
        Trt3  0.00000      0.00000      0.00000    
             Location ^ 7 Location ^ 8     Trt1     Trt2 
  Location.L                                            
  Location.Q                                            
  Location.C                                            
Location ^ 4                                            
Location ^ 5                                            
Location ^ 6                                            
Location ^ 7                                            
Location ^ 8  0.00000                                   
        Trt1  0.00000      0.00000                      
        Trt2  0.00000      0.00000      0.50000         
        Trt3  0.00000      0.00000      0.50000  0.50000

Standardized Within-Group Residuals:
     Min       Q1       Med      Q3    Max 
 -2.1252 -0.65589 -0.092083 0.61607 2.9343

Number of Observations: 108
Number of Groups: 27 
S> fm2RMult <- update( fm2Mult, REML = TRUE ) # get REML estimates
S> summary( fm2RMult )
Linear mixed-effects model fit by REML
 Data: Multilocation 
     AIC    BIC logLik 
  24.198 60.099  1.901

Random effects:
 Formula:  ~ 1 | Grp
        (Intercept) Residual 
StdDev:    0.071319  0.19161

Fixed effects:  Adj ~ Location + Trt 
              Value Std.Error z-value p-value 
 (Intercept)  2.866     0.039  72.830   0.000
  Location.L  0.918     0.069  13.307   0.000
  Location.Q  0.003     0.069   0.038   0.970
  Location.C  0.079     0.069   1.140   0.254
Location ^ 4 -0.163     0.069  -2.370   0.018
Location ^ 5  0.066     0.069   0.954   0.340
Location ^ 6  0.047     0.069   0.683   0.495
Location ^ 7 -0.242     0.069  -3.512   0.000
Location ^ 8  0.123     0.069   1.791   0.073
        Trt1  0.058     0.052   1.119   0.263
        Trt2 -0.188     0.052  -3.605   0.000
        Trt3  0.084     0.052   1.607   0.108
 Correlation: 
             (Intercept) Location.L Location.Q Location.C 
  Location.L  0.00000                                    
  Location.Q  0.00000     0.00000                        
  Location.C  0.00000     0.00000    0.00000             
Location ^ 4  0.00000     0.00000    0.00000    0.00000  
Location ^ 5  0.00000     0.00000    0.00000    0.00000  
Location ^ 6  0.00000     0.00000    0.00000    0.00000  
Location ^ 7  0.00000     0.00000    0.00000    0.00000  
Location ^ 8  0.00000     0.00000    0.00000    0.00000  
        Trt1 -0.66269     0.00000    0.00000    0.00000  
        Trt2 -0.66269     0.00000    0.00000    0.00000  
        Trt3 -0.66269     0.00000    0.00000    0.00000  
             Location ^ 4 Location ^ 5 Location ^ 6 
  Location.L                                       
  Location.Q                                       
  Location.C                                       
Location ^ 4                                       
Location ^ 5  0.00000                              
Location ^ 6  0.00000      0.00000                 
Location ^ 7  0.00000      0.00000      0.00000    
Location ^ 8  0.00000      0.00000      0.00000    
        Trt1  0.00000      0.00000      0.00000    
        Trt2  0.00000      0.00000      0.00000    
        Trt3  0.00000      0.00000      0.00000    
             Location ^ 7 Location ^ 8     Trt1     Trt2 
  Location.L                                            
  Location.Q                                            
  Location.C                                            
Location ^ 4                                            
Location ^ 5                                            
Location ^ 6                                            
Location ^ 7                                            
Location ^ 8  0.00000                                   
        Trt1  0.00000      0.00000                      
        Trt2  0.00000      0.00000      0.50000         
        Trt3  0.00000      0.00000      0.50000  0.50000

Standardized Within-Group Residuals:
     Min       Q1      Med      Q3    Max 
 -2.0602 -0.65878 -0.05975 0.60979 2.6209

Number of Observations: 108
Number of Groups: 27 
S> ### Treating the location as a random effect
S> fm1MultR <- lme( Adj ~ Trt, data = Multilocation,
+   random = list( Location = pdCompSymm( ~ Trt - 1 ), Block = ~ 1 ) )
S> summary( fm1MultR )
Linear mixed-effects model fit by maximum likelihood
 Data: Multilocation 
     AIC    BIC logLik 
  2.3585 23.816 6.8208

Random effects:
 Formula:  ~ Trt - 1 | Location
 Structure: Compound Symmetry
     StdDev  Corr             
Trt1 1.8464                  
Trt2 1.8464 0.992            
Trt3 1.8464 0.992 0.992      
Trt4 1.8464 0.992 0.992 0.992

 Formula:  ~ 1 | Block %in% Location
        (Intercept) Residual 
StdDev:     0.07497  0.18596

Fixed effects:  Adj ~ Trt 
             Value Std.Error z-value p-value 
(Intercept)  2.866     0.113  25.310   0.000
       Trt1  0.058     0.052   1.116   0.264
       Trt2 -0.188     0.052  -3.596   0.000
       Trt3  0.084     0.052   1.602   0.109
 Correlation: 
     (Intercept)     Trt1     Trt2 
Trt1 -0.23091                     
Trt2 -0.23091     0.50000         
Trt3 -0.23091     0.50000  0.50000

Standardized Within-Group Residuals:
     Min       Q1       Med      Q3    Max 
 -2.0977 -0.64771 -0.062192 0.58973 2.6188

Number of Observations: 108
Number of Groups: 
 Location Block %in% Location 
        9                  27
S> fm2MultR <- update( fm1MultR, random = list( Location = ~ Trt - 1, Block = ~ 1 ))
S> anova( fm1MultR, fm2MultR )
         Model df    AIC    BIC logLik    Test Lik.Ratio 
fm1MultR     1  8  2.358 23.816 6.8208                  
fm2MultR     2 16 15.827 58.741 8.0866 1 vs. 2    2.5316
         p-value 
fm1MultR        
fm2MultR 0.96024
S> ## No indication that a general variance-covariance is preferred to
S> ## a compound symmetry structure.
S> fm1RMultR <- update( fm1MultR, REML = TRUE )
S> summary( fm1RMultR )
Linear mixed-effects model fit by REML
 Data: Multilocation 
     AIC    BIC  logLik 
  17.615 38.771 -0.8077

Random effects:
 Formula:  ~ Trt - 1 | Location
 Structure: Compound Symmetry
     StdDev Corr           
Trt1 1.1431               
Trt2 1.1431 0.98          
Trt3 1.1431 0.98 0.98     
Trt4 1.1431 0.98 0.98 0.98

 Formula:  ~ 1 | Block %in% Location
        (Intercept) Residual 
StdDev:     0.07497  0.18596

Fixed effects:  Adj ~ Trt 
             Value Std.Error z-value p-value 
(Intercept)  2.866     0.120  23.863   0.000
       Trt1  0.058     0.055   1.052   0.293
       Trt2 -0.188     0.055  -3.390   0.001
       Trt3  0.084     0.055   1.511   0.131
 Correlation: 
     (Intercept)     Trt1     Trt2 
Trt1 -0.23091                     
Trt2 -0.23091     0.50000         
Trt3 -0.23091     0.50000  0.50000

Standardized Within-Group Residuals:
     Min       Q1       Med      Q3    Max 
 -1.9836 -0.67421 -0.030869 0.53897 2.6269

Number of Observations: 108
Number of Groups: 
 Location Block %in% Location 
        9                  27
S> c( 0.34116, 0.07497, 0.18596)^2  # compare with estimates, p. 84
[1] 0.1163901 0.0056205 0.0345811
