S> ### $Id: Semiconductor.St,v 1.1 1998/04/10 23:04:02 bates Exp $
S> ### Analysis of the Semiconductor split-plot experiment, section 2.3 of
S> ### "SAS System for Mixed Models"
S> options(contrasts = c(factor = "contr.SAS", ordered = "contr.poly"))
S> formula( Semiconductor )
resistance ~ 1 | Grp
S> plot( Semiconductor )
S> names( Semiconductor )
[1] "resistance" "ET"         "Wafer"      "position"  
[5] "Grp"       
S> plot( Semiconductor, inner = ~ position )
S> fm1Semi <- lme( resistance ~ ET * position,
+                  data = Semiconductor,
+                  random = ~ 1 | Grp )
S> summary( fm1Semi )
Linear mixed-effects model fit by maximum likelihood
 Data: Semiconductor 
     AIC    BIC  logLik 
  66.147 99.828 -15.073

Random effects:
 Formula:  ~ 1 | Grp
        (Intercept) Residual 
StdDev:     0.26557  0.27221

Fixed effects:  resistance ~ ET * position 
              Value Std.Error z-value p-value 
 (Intercept)  6.540     0.220  29.786   0.000
         ET1 -0.653     0.311  -2.104   0.035
         ET2 -0.623     0.311  -2.007   0.045
         ET3 -0.447     0.311  -1.438   0.150
   position1 -0.200     0.222  -0.900   0.368
   position2  0.013     0.222   0.060   0.952
   position3 -0.643     0.222  -2.895   0.004
ET1position1 -0.073     0.314  -0.233   0.816
ET2position1  0.277     0.314   0.880   0.379
ET3position1  0.243     0.314   0.774   0.439
ET1position2 -0.450     0.314  -1.432   0.152
ET2position2  0.257     0.314   0.817   0.414
ET3position2  0.240     0.314   0.764   0.445
ET1position3  0.310     0.314   0.986   0.324
ET2position3  0.493     0.314   1.570   0.117
ET3position3  0.323     0.314   1.029   0.304
 Correlation: 
             (Intercept)      ET1      ET2      ET3 position1 
         ET1 -0.70711                                        
         ET2 -0.70711     0.50000                            
         ET3 -0.70711     0.50000  0.50000                   
   position1 -0.50614     0.35789  0.35789  0.35789          
   position2 -0.50614     0.35789  0.35789  0.35789  0.50000 
   position3 -0.50614     0.35789  0.35789  0.35789  0.50000 
ET1position1  0.35789    -0.50614 -0.25307 -0.25307 -0.70711 
ET2position1  0.35789    -0.25307 -0.50614 -0.25307 -0.70711 
ET3position1  0.35789    -0.25307 -0.25307 -0.50614 -0.70711 
ET1position2  0.35789    -0.50614 -0.25307 -0.25307 -0.35355 
ET2position2  0.35789    -0.25307 -0.50614 -0.25307 -0.35355 
ET3position2  0.35789    -0.25307 -0.25307 -0.50614 -0.35355 
ET1position3  0.35789    -0.50614 -0.25307 -0.25307 -0.35355 
ET2position3  0.35789    -0.25307 -0.50614 -0.25307 -0.35355 
ET3position3  0.35789    -0.25307 -0.25307 -0.50614 -0.35355 
             position2 position3 ET1position1 ET2position1 
         ET1                                              
         ET2                                              
         ET3                                              
   position1                                              
   position2                                              
   position3  0.50000                                     
ET1position1 -0.35355  -0.35355                           
ET2position1 -0.35355  -0.35355   0.50000                 
ET3position1 -0.35355  -0.35355   0.50000      0.50000    
ET1position2 -0.70711  -0.35355   0.50000      0.25000    
ET2position2 -0.70711  -0.35355   0.25000      0.50000    
ET3position2 -0.70711  -0.35355   0.25000      0.25000    
ET1position3 -0.35355  -0.70711   0.50000      0.25000    
ET2position3 -0.35355  -0.70711   0.25000      0.50000    
ET3position3 -0.35355  -0.70711   0.25000      0.25000    
             ET3position1 ET1position2 ET2position2 
         ET1                                       
         ET2                                       
         ET3                                       
   position1                                       
   position2                                       
   position3                                       
ET1position1                                       
ET2position1                                       
ET3position1                                       
ET1position2  0.25000                              
ET2position2  0.25000      0.50000                 
ET3position2  0.50000      0.50000      0.50000    
ET1position3  0.25000      0.50000      0.25000    
ET2position3  0.25000      0.25000      0.50000    
ET3position3  0.50000      0.25000      0.25000    
             ET3position2 ET1position3 ET2position3 
         ET1                                       
         ET2                                       
         ET3                                       
   position1                                       
   position2                                       
   position3                                       
ET1position1                                       
ET2position1                                       
ET3position1                                       
ET1position2                                       
ET2position2                                       
ET3position2                                       
ET1position3  0.25000                              
ET2position3  0.25000      0.50000                 
ET3position3  0.50000      0.50000      0.50000    

Standardized Within-Group Residuals:
     Min      Q1    Med      Q3    Max 
 -2.3406 -0.5624 0.0126 0.57402 1.6062

Number of Observations: 48
Number of Groups: 12 
S> ## check significance of the interaction
S> fm2Semi <- update( fm1Semi, resistance ~ ET + position )
S> fm3Semi <- update( fm1Semi, resistance ~ ET )
S> fm4Semi <- update( fm1Semi, resistance ~ position )
S> fm5Semi <- update( fm1Semi, resistance ~ 1 )
S> anova( fm5Semi, fm4Semi, fm2Semi, fm1Semi )
        Model df    AIC    BIC  logLik    Test Lik.Ratio 
fm5Semi     1  3 62.373 67.987 -28.187                  
fm4Semi     2  6 58.251 69.479 -23.126 1 vs. 2    10.122
fm2Semi     3  9 57.687 74.528 -19.844 2 vs. 3     6.564
fm1Semi     4 18 66.147 99.828 -15.073 3 vs. 4     9.540
        p-value 
fm5Semi        
fm4Semi 0.01756
fm2Semi 0.08717
fm1Semi 0.38895
S> anova( fm5Semi, fm3Semi, fm2Semi, fm1Semi )
        Model df    AIC    BIC  logLik    Test Lik.Ratio 
fm5Semi     1  3 62.373 67.987 -28.187                  
fm3Semi     2  6 61.809 73.036 -24.905 1 vs. 2     6.564
fm2Semi     3  9 57.687 74.528 -19.844 2 vs. 3    10.122
fm1Semi     4 18 66.147 99.828 -15.073 3 vs. 4     9.540
        p-value 
fm5Semi        
fm3Semi 0.08717
fm2Semi 0.01756
fm1Semi 0.38895
S> ## AIC favors resistance ~ ET + position
S> ## BIC favors resistance ~ 1
S> ## Likelihood ratio seems to favor resistance ~ position
