#include<X11/X.h>
#include<X11/IntrinsicP.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/Shell.h>
#include<X11/Core.h>
#include<tcl.h>
#include<tk.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
typedef struct mbx_entry { int flags;
#define F_SELECTED 1
#define F_ISELECTED 2
char *str; } mbx_entry; typedef struct mbx_data { Tk_Window tw; Tcl_Interp *interp; int ue; int ne; char *xsbar; char *ysbar; char *onproc; char *offproc; char *invstr; char *ionproc; char *ioffproc; int iwd; int xsc; int first; mbx_entry *entries; } mbx_data; enum { BLACK = 0, WHITE, RED, GREEN, BLUE, DARKGRAY, GRAY }; static unsigned long int colors[16]; static Font f; int multibox(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int mbx_proc(ClientData cd, Tcl_Interp *interp, int argc, char **argv); void mbx_add(mbx_data *m, char *str); void mbx_paint(ClientData cd, XEvent *ep); void mbx_click(ClientData cd, XEvent *ev); void mbx_free(ClientData cd); long int fetch_color(Tcl_Interp *interp, char *colorname, Tk_Window tkwin) { XColor *color; color = Tk_GetColor(interp, tkwin, Tk_GetUid(colorname)); return color->pixel; } int Mbx_Init(Tcl_Interp *interp) { Tk_Window tw; Tcl_CreateCommand(interp, "multibox", multibox, NULL, NULL); tw = Tk_MainWindow(interp); colors[BLACK] = fetch_color(interp, "black", tw); colors[WHITE] = fetch_color(interp, "white", tw); colors[RED] = fetch_color(interp, "red", tw); colors[GREEN] = fetch_color(interp, "green", tw); colors[BLUE] = fetch_color(interp, "blue", tw); colors[DARKGRAY] = fetch_color(interp, "darkgray", tw); colors[GRAY] = fetch_color(interp, "gray", tw); f = XLoadFont(Tk_Display(tw), "-*-Helvetica-Bold-R-Normal--*-100-*"); return TCL_OK; } int multibox(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { Tk_Window par; char *path, *name, *i; mbx_data *m; if (argc < 8) { printf("insufficient arguments to multibox creation function\n"); return TCL_ERROR; } m = (mbx_data *) malloc(sizeof(mbx_data)); path = strdup(argv[1]); for (i = path, name = 0; *i; i++) if (*i == '.') name = i; if (!name) { name = path; par = Tk_MainWindow(interp); } else { *name = 0; name++; if (*path) par = Tk_NameToWindow(interp, path, Tk_MainWindow(interp)); else par = Tk_MainWindow(interp); } m->tw = Tk_CreateWindow(interp, par, name, NULL); Tk_MapWindow(m->tw); Tk_ResizeWindow(m->tw, 100, 100); Tcl_CreateCommand(interp, argv[1], mbx_proc, m, mbx_free); Tk_CreateEventHandler(m->tw, ExposureMask, mbx_paint, m); Tk_CreateEventHandler(m->tw, ButtonPress, mbx_click, m); m->interp = interp; m->xsc = 0; m->entries = (mbx_entry *) malloc(16*sizeof(mbx_entry)); m->ue = 0; m->ne = 16; m->first = 0; m->xsbar = strdup(argv[2]); m->ysbar = strdup(argv[3]); m->onproc = strdup(argv[4]); m->offproc = strdup(argv[5]); m->ionproc = strdup(argv[6]); m->ioffproc = strdup(argv[7]); if (argc > 8) { m->invstr = strdup(argv[8]); m->iwd = 10*strlen(m->invstr); } else { m->invstr = 0; m->iwd = 0; } return TCL_OK; } int mbx_proc(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char buf[256]; int am, om; int s=0; int u=0; int is=0; int iu=0; int i, n; mbx_data *m = (mbx_data *) cd; if (argc > 1) { if (!strcmp(argv[1], "add") && (argc == 3)) { if (!strcmp(argv[2], "ALL")) { fprintf(stderr, "sorry, you cannot have a multibox entry named \"ALL\".\n"); return(TCL_ERROR); } else { mbx_add(m, argv[2]); mbx_paint(cd, NULL); } } else if (!strcmp(argv[1], "paint")) { mbx_paint(cd, NULL); } else if ((s = !strcmp(argv[1], "select")) || (u = !strcmp(argv[1], "unselect")) || (is = !strcmp(argv[1], "iselect")) || (iu = !strcmp(argv[1], "iunselect")) && (argc >= 3)) { n = atoi(argv[2]); if (!n && !strcmp(argv[2], "ALL")) { am = ~0; om = 0; if (s) om = F_SELECTED; else if (u) am = ~F_SELECTED; else if (is) om = F_ISELECTED; else if (iu) am = ~F_ISELECTED; for (i = 0; i < m->ue; i++) { m->entries[i].flags &= am; m->entries[i].flags |= om; } } else { if (!n) { for (i = 0; i < m->ue; i++) if (!strcmp(m->entries[i].str, argv[2])) { n = i; break; } } else n--; if (s) m->entries[n].flags |= F_SELECTED; else if (u) m->entries[n].flags &= ~F_SELECTED; else if (is) m->entries[n].flags |= F_ISELECTED; else if (iu) m->entries[n].flags &= ~F_ISELECTED; } if (argc == 3) mbx_paint(cd, NULL); } else if (!strcmp(argv[1], "xview")) { m->xsc = -1 * atol(argv[2]); if(m->xsc > 0) m->xsc = 0; sprintf(buf, "%s set %i %i %i %i\n", m->xsbar, 1000, 100, -1 * m->xsc, -1 * m->xsc + 100); Tcl_Eval(interp, buf); mbx_paint(m, NULL); } else if (!strcmp(argv[1], "yview")) { m->first = atof(argv[2]); n = Tk_Height(m->tw)/14; if (m->first + n >= m->ue) m->first = m->ue - n; if (m->first < 0) m->first = 0; sprintf(buf, "%s set %i %i %i %i\n", m->ysbar, m->ue, Tk_Height(m->tw)/14, m->first, m->first + n - 1); Tcl_Eval(interp, buf); mbx_paint(m, NULL); } } return TCL_OK; } void mbx_add(mbx_data *m, char *str) { if (m->ne <= m->ue) { m->ne += 16; m->entries = realloc(m->entries, m->ne * sizeof(mbx_entry)); } m->entries[m->ue].flags = 0; m->entries[m->ue].str = strdup(str); m->ue++; } void mbx_paint(ClientData cd, XEvent *ep) { int i, last; GC gc; Display *disp; mbx_data *m = (mbx_data *) cd; Drawable d = Tk_WindowId(m->tw); disp = Tk_Display(m->tw); gc = XCreateGC(disp, d, 0, NULL); XSetFont(disp, gc, f); last = m->first + Tk_Height(m->tw)/14; if (last > m->ue) last = m->ue; for (i = m->first; i < last; i++) { if (m->entries[i].flags & F_SELECTED) { XSetForeground(disp, gc, colors[BLACK]); XFillRectangle(disp, d, gc, m->iwd, (i - m->first)*14, Tk_Width(m->tw), 14); XSetForeground(disp, gc, colors[WHITE]); XDrawString(disp, d, gc, m->xsc + m->iwd, 10 + (i - m->first)*14, m->entries[i].str, strlen(m->entries[i].str)); } else { XSetForeground(disp, gc, colors[WHITE]); XFillRectangle(disp, d, gc, m->iwd, (i - m->first)*14, Tk_Width(m->tw), 14); XSetForeground(disp, gc, colors[BLACK]); XDrawString(disp, d, gc, m->xsc + m->iwd, 10 + (i - m->first)*14, m->entries[i].str, strlen(m->entries[i].str)); } if (m->invstr) { XSetForeground(disp, gc, colors[WHITE]); XFillRectangle(disp, d, gc, 0, (i - m->first)*14, m->iwd, 14); XSetForeground(disp, gc, colors[DARKGRAY]); XDrawRectangle(disp, d, gc, 2, (i - m->first)*14 + 2, 10, 10); XSetForeground(disp, gc, colors[BLACK]); if (m->entries[i].flags & F_ISELECTED) { XDrawLine(disp, d, gc, 3, (i - m->first)*14 + 3, 3, (i - m->first)*14 + 11); XDrawLine(disp, d, gc, 3, (i - m->first)*14 + 3, 11, (i - m->first)*14 + 3); XSetForeground(disp, gc, colors[RED]); XFillRectangle(disp, d, gc, 4, (i - m->first)*14 + 4, 7, 7); } else { XDrawLine(disp, d, gc, 11, (i - m->first)*14 + 11, 3, (i - m->first)*14 + 11); XDrawLine(disp, d, gc, 11, (i - m->first)*14 + 11, 11, (i - m->first)*14 + 3); XSetForeground(disp, gc, colors[GRAY]); XFillRectangle(disp, d, gc, 4, (i - m->first)*14 + 4, 7, 7); } } } XSetForeground(disp, gc, colors[WHITE]); XFillRectangle(disp, d, gc, 0, (i - m->first)*14, Tk_Width(m->tw), Tk_Height(m->tw) - (i - m->first)*14); XFreeGC(disp, gc); } void mbx_click(ClientData cd, XEvent *ev) { XButtonEvent *mouse; int n; static char buf[256]; mbx_data *m = (mbx_data *) cd; mouse = (XButtonEvent *) ev; n = (mouse->y/14) + m->first; if ((0 <= n) && (n < m->ue)) { if (mouse->x < m->iwd) { m->entries[n].flags ^= F_ISELECTED; if (m->entries[n].flags & F_ISELECTED) { sprintf(buf, "%s %i {%s}", m->ionproc, n+1, m->entries[n].str); } else { sprintf(buf, "%s %i {%s}", m->ioffproc, n+1, m->entries[n].str); } } else { m->entries[n].flags ^= F_SELECTED; if (m->entries[n].flags & F_SELECTED) { sprintf(buf, "%s %i {%s}", m->onproc, n+1, m->entries[n].str); } else { sprintf(buf, "%s %i {%s}", m->offproc, n+1, m->entries[n].str); } } mbx_paint(cd, NULL); Tcl_Eval(m->interp, buf); } } void mbx_free(ClientData cd) { int i; mbx_data *m = (mbx_data *) cd; Tk_DestroyWindow(m->tw); for (i = 0; i < m->ue; i++) free(m->entries[i].str); free(m->onproc); free(m->offproc); free(m->ionproc); free(m->ioffproc); if (m->invstr) free(m->invstr); free(m); }