
#include<X11/X.h>
#include<X11/IntrinsicP.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/Shell.h>
#include<X11/Core.h>
#include<tcl.h>
#include<tk.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<signal.h>
typedef struct ts_stack_elem { void *previous; void *data; } stack_elem; typedef stack_elem **stack; stack make_stack(void) { stack s; s = (stack) malloc(sizeof(stack_elem *)); *s = 0; return s; } void stack_push(stack s, void *d) { stack_elem *e; e = (stack_elem *) malloc(sizeof(stack_elem)); e->previous = *s; e->data = d; *s = e; } void stack_pop(stack s, void **d) { stack_elem *e; e = *s; if (e) { *s = e->previous; *d = e->data; free(e); } else *d = 0; } typedef struct vector { int q, c; void **d; } vector; vector *mk_vector(int isz) { vector *v = (vector *) malloc(sizeof(vector)); v->q = 0; v->c = isz; v->d = (void **) malloc(v->c * sizeof(void *)); return v; } void rm_vector(vector *v) { free(v->d); free(v); } void vector_add(vector *v, void *d) { v->d[v->q] = d; if (++v->q >= v->c) { v->c += 16; v->d = (void **) realloc(v->d, v->c * sizeof(void *)); } } static int x_svector_cmp(char **a, char **b) { return -strcmp(*a, *b); } void svector_qsort(vector *v) { qsort(v->d, v->q, sizeof(char *), (int (*)(const void *, const void *))x_svector_cmp); } typedef struct strbucket { struct strbucket *c; char *s; int flags; } strbucket; int hashfn(char *str) { int h = 0, i = 0; for (; *str; i++, str++) h+= *str << ((i/(*str+1)+*str/(i+1)+h/(*str+i+1))&7); return h&0xff; } void get_hkdp(strbucket *bks, int nbks, char *str, int *hk, int *dp) { strbucket *b; int h, i=0; h = hashfn(str) & ((1<<nbks)-1); *hk = h; if (bks[h].s) for (i = 0, b = &bks[h]; b->c&&b->s&&strcmp(str, b->s); i++, b = b->c); *dp = i; } int add_str(strbucket *bks, int nbks, char *nstr, int *hk, int *dp) { strbucket *b; int h, i; h = hashfn(nstr) & ((1<<nbks)-1); if (bks[h].s) { for (i = 0, b = &bks[h]; b->c&&b->s&&strcmp(nstr, b->s); i++, b = b->c); if (!strcmp(nstr, b->s)) { *dp = i; } else {if (b->c = (strbucket *) malloc(sizeof(strbucket))) { b->c->c = 0; b->c->s = strdup(nstr); *dp = i+1; b->c->flags=0; } else return 0;} } else { bks[h].s = strdup(nstr); *dp = 0; } *hk = h; return 1; } char *get_str(strbucket *bks, int nbks, int hk, int dp) { strbucket *b; int i; for (i = 0, b = &bks[hk]; (i < dp)&&(b->c); i++, b = b->c); if (i == dp) { if (b->s) return b->s; else return "(no text)"; } else return "(no text)"; } int get_flags(strbucket *bks, int nbks, int hk, int dp) { strbucket *b; int i; for (i = 0, b = &bks[hk]; (i < dp)&&(b->c); i++, b = b->c); if (i == dp) { if (b->s) return b->flags; else return 0; } else return 0; } void set_flags(strbucket *bks, int nbks, int hk, int dp, int fv) { strbucket *b; int i; for (i = 0, b = &bks[hk]; (i < dp)&&(b->c); i++, b = b->c); if ((i == dp) && (b->s)) { b->flags = fv; } } void del_bk(strbucket *b) { if (b->c) { del_bk(b->c); free(b->c); } if (b->s) free(b->s); } void del_bks(strbucket *bks, int nbks) { int i, n; n = (1<<nbks)-1; for (i = 0; i < n; i++) del_bk(&bks[i]); }
#define WARP_POINTER
#define F_SHI 1
#define INIT_TREE_X_SIZE 640
#define INIT_TREE_Y_SIZE 480
#define V_NODECOUNT 0
#define V_MEANCHILD 1
#define V_MAXCHILD 2
#define MIN_CIRCLE_WIDTH 16
#define C_BLACK 0
#define C_WHITE 1
#define C_NODE 2
#define C_NODE_HIGHLIGHT 3
#define C_NODE_OVER 4
#define C_FILTER 5
#define C_TRACE 6
#define C_RED 7
#define C_BLUE 8
#define C_GREEN 9
#define C_ASSERTVIO 10
#define C_DEADLOCK 11
#define C_ABORT 12
#define F_SHOWCOMMENTS 1
#define F_CLEARTRACE 2
#define F_IN_PRUNED 4
#define F_SIMULATORBUSY 8
#define F_UPDATE 16
#define T_ASSERTVIO 1
#define T_DEADLOCK 2
#define T_ABORT 3
#define HLF_HIGHLIT 1
#define HLF_FILTERED 2
#define HLF_TRACEDTO 4
#define HLF_TRACEDTHROUGH 8
#define HLF_TRACED 12
#define HLF_ASSERTVIO 16
#define HLF_DEADLOCK 32
#define HLF_ABORT 64
#define CHKPT(j) (ckpt = (j))
static int ckpt; static Tcl_Interp *intp; static old_dest=0; typedef struct node_row { int depth; int csznodes; int qtynodes; int *nodes; int direction; } node_row; typedef struct node { int parent; int rsib, lchild; int depth; int row; int x, y; int hlflags; int label, pid, toss; int hk, dp; } node; typedef struct treeview { Display *disp; GC tree_gc; Tk_Window canvas_window, tree_window; char *status_bar; char *lbl_mbx, *pid_mbx; int xsz, ysz; long int colors[16]; node_row *noderows; int qtynrows; int csznrows; node *allnodes; int qtynodes; int csznodes; int lastnode; float origin_x, origin_y; int clicked_node; float dot_width, row_space, index_space, img_width; Tcl_Interp *interp; strbucket *bks; int bksz; int flags; int current_state; int n_pids; Font f; char *pidhi; } treeview; int fread_tree(FILE *file, treeview *proto_tv, char *keypath); void add_trans(treeview *tv, int org, int dest, int label, int pid, int toss, int type, char *str); static void tree_repaint(ClientData tkcd, XEvent *ev); static void tree_paint(ClientData tkcd); static void tree_mouse_moved(ClientData tkcd, XEvent *ev); long int fetch_color(Tcl_Interp *interp, char *colorname, Tk_Window tkwin); void cache_colors(Tcl_Interp *interp, treeview *tv); static void tree_button_pressed(ClientData tkcd, XEvent *ev); void find_coords_by_node(treeview *tv, int row, int idx, int *x, int *y); int tree_paint_it(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_center(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_zoom_examine(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_zoom_overall(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_zoom_in(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_zoom_out(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_set_x(ClientData cd, Tcl_Interp *interp, int argc, char **arg); int tree_set_y(ClientData cd, Tcl_Interp *interp, int argc, char **arg); int tree_configure(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_filter(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_trace_to_state(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int tree_transition(ClientData cd, Tcl_Interp *interp, int argc, char **argv); int create_tree(ClientData cd, Tcl_Interp *interp, int argc, char **argv); void sigsegv(int x) { fprintf(stderr, "VeriSoft Simulator Quitting...(Code %i)\n", ckpt); exit(0); } int Sss_Init(Tcl_Interp *interp) { intp=interp; Tcl_CreateCommand(interp, "veritree", create_tree, NULL, NULL); signal(SIGSEGV, sigsegv); return TCL_OK; } int create_tree(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { FILE *file; treeview *proto_tv; strbucket *s; int n, i; char buf[256]; vector *v; if(argc != 7) { printf("usage: veritree <canvas> <statusbar> <text-listbox> <pid-listbox> <key/legend-path> <treefile>\n"); return TCL_OK; } proto_tv = (treeview *) malloc(sizeof(treeview)); proto_tv->interp = interp; proto_tv->flags = 0; proto_tv->xsz = INIT_TREE_X_SIZE; proto_tv->ysz = INIT_TREE_Y_SIZE; proto_tv->origin_x = proto_tv->xsz / 2; proto_tv->origin_y = 100; proto_tv->clicked_node = -1; proto_tv->dot_width = 1; proto_tv->row_space = 6; proto_tv->index_space = 9; proto_tv->img_width = 20; proto_tv->status_bar = strdup(argv[2]); proto_tv->lbl_mbx = strdup(argv[3]); proto_tv->pid_mbx = strdup(argv[4]); proto_tv->bksz = 8; proto_tv->bks = (strbucket *) malloc(sizeof(strbucket)*(1<<proto_tv->bksz)); for(i = 0; i < (1<<proto_tv->bksz); i++) { proto_tv->bks[i].s = 0; proto_tv->bks[i].c = 0; proto_tv->bks[i].flags=0; } proto_tv->canvas_window = Tk_NameToWindow(interp, argv[1], Tk_MainWindow(interp)); proto_tv->tree_window = Tk_CreateWindow(interp, proto_tv->canvas_window, "veritree", NULL); Tk_MapWindow(proto_tv->tree_window); Tk_MoveResizeWindow(proto_tv->tree_window, 0, 0, 640, 480); Tk_MakeWindowExist(proto_tv->tree_window); if(!proto_tv->tree_window) { fprintf(stderr, "Error!\n%s\n", interp->result); exit(1); } proto_tv->tree_gc = Tk_GetGC(proto_tv->tree_window, 0, NULL); proto_tv->qtynrows = 0; proto_tv->csznrows = 16; proto_tv->noderows = (node_row *) malloc(proto_tv->csznrows*sizeof(node_row)); proto_tv->qtynodes = 1; proto_tv->csznodes = 16; proto_tv->current_state = 0; proto_tv->allnodes = (node *) malloc(proto_tv->csznodes*sizeof(node)); proto_tv->qtynrows = 1; proto_tv->n_pids = 0; proto_tv->noderows[0].depth = 0; proto_tv->noderows[0].csznodes = 4; proto_tv->noderows[0].qtynodes = 1; proto_tv->noderows[0].direction = 1; proto_tv->noderows[0].nodes = (int *) malloc(4*sizeof(int)); proto_tv->noderows[0].nodes[0] = 0; proto_tv->allnodes[0].parent = 0; proto_tv->allnodes[0].rsib = 0; proto_tv->allnodes[0].lchild = 0; proto_tv->allnodes[0].depth = 0; proto_tv->allnodes[0].row = 0; proto_tv->allnodes[0].x = 0; proto_tv->allnodes[0].y = 0; proto_tv->allnodes[0].hlflags = HLF_TRACED; proto_tv->allnodes[0].label = 0; proto_tv->allnodes[0].pid = 0; proto_tv->allnodes[0].toss = 0; add_str(proto_tv->bks, proto_tv->bksz, "(initial state)", &(proto_tv->allnodes[0].hk), &(proto_tv->allnodes[0].dp)); CHKPT(1); if (!(file = fopen(argv[6], "r"))) { fprintf(stderr,"VeriSoft Error: cannot read sss.VS !\n"); return TCL_ERROR; }; fread_tree(file, proto_tv, argv[5]); fclose(file); CHKPT(2); proto_tv->pidhi = (char *) malloc((proto_tv->n_pids+1) * sizeof(char)); proto_tv->pidhi[0] = 0; for(i = 1; i < proto_tv->n_pids; i++) { sprintf(buf, "%s add %i", proto_tv->pid_mbx, i); Tcl_Eval(proto_tv->interp, buf); proto_tv->pidhi[i]=0; } sprintf(buf, "%s iselect ALL", proto_tv->pid_mbx); Tcl_Eval(proto_tv->interp, buf); v = mk_vector(16); for(i = 0; i < (1<<proto_tv->bksz); i++) { s = &proto_tv->bks[i]; while(s) { if(s->s) vector_add(v, s->s); s = s->c; } } svector_qsort(v); for(i = 0; i < v->q; i++) { sprintf(buf, "%s add {%s}", proto_tv->lbl_mbx, v->d[i]); Tcl_Eval(proto_tv->interp, buf); } rm_vector(v); proto_tv->lastnode = 0; proto_tv->disp = Tk_Display(proto_tv->tree_window); Tk_CreateEventHandler(proto_tv->tree_window, PointerMotionMask, tree_mouse_moved, (ClientData) proto_tv); Tk_CreateEventHandler(proto_tv->tree_window, ButtonPress, tree_button_pressed, (ClientData) proto_tv); Tk_CreateEventHandler(proto_tv->tree_window, ExposureMask, tree_repaint, (ClientData) proto_tv); sprintf(buf, "%s.paint", argv[1]); Tcl_CreateCommand(interp, buf, tree_paint_it, proto_tv, NULL); sprintf(buf, "%s.center", argv[1]); Tcl_CreateCommand(interp, buf, tree_center, proto_tv, NULL); sprintf(buf, "%s.zoom_examine", argv[1]); Tcl_CreateCommand(interp, buf, tree_zoom_examine, proto_tv, NULL); sprintf(buf, "%s.zoom_overall", argv[1]); Tcl_CreateCommand(interp, buf, tree_zoom_overall, proto_tv, NULL); sprintf(buf, "%s.zoom_in", argv[1]); Tcl_CreateCommand(interp, buf, tree_zoom_in, proto_tv, NULL); sprintf(buf, "%s.zoom_out", argv[1]); Tcl_CreateCommand(interp, buf, tree_zoom_out, proto_tv, NULL); sprintf(buf, "%s.setx", argv[1]); Tcl_CreateCommand(interp, buf, tree_set_x, proto_tv, NULL); sprintf(buf, "%s.sety", argv[1]); Tcl_CreateCommand(interp, buf, tree_set_y, proto_tv, NULL); sprintf(buf, "%s.configure", argv[1]); Tcl_CreateCommand(interp, buf, tree_configure, proto_tv, NULL); sprintf(buf, "%s.trace", argv[1]); Tcl_CreateCommand(interp, buf, tree_trace_to_state, proto_tv, NULL); sprintf(buf, "%s.transition", argv[1]); Tcl_CreateCommand(interp, buf, tree_transition, proto_tv, NULL); sprintf(buf, "%s.filter", argv[1]); Tcl_CreateCommand(interp, buf, tree_filter, proto_tv, NULL); cache_colors(interp, proto_tv); tree_paint(proto_tv); return TCL_OK; } int fread_tree(FILE *file, treeview *proto_tv, char *keypath) { char buf[256],buf2[256]; int org, dest, label, pid, toss, type; int n_bads[4] = { 0, 0, 0, 0 }; int i; int nbr_of_leafs=0; node *allnodes; fgets(buf, 256, file); while(fscanf(file, "%d %d %d %d %d ", &org, &dest, &label, &pid, &toss) != EOF) { fgets(buf, 256, file); buf[strlen(buf)-1] = 0; fgets(buf2, 256, file); type = atol(buf2); if((1 <= type) && (type <= 3)) n_bads[type]++; if (dest != (old_dest+1)) { printf("Warning: the end of sss.VS is corrupted...\n"); break; }; old_dest++; if(pid) add_trans(proto_tv, org, dest, label, pid, toss, type, buf); } allnodes = proto_tv->allnodes; for (i=0;i<=old_dest;i++){ if (allnodes[i].lchild == 0) nbr_of_leafs++; }; sprintf(buf, "label %s.asv -text \"Assertion Violations: %i\" -bg red", keypath, n_bads[T_ASSERTVIO]); Tcl_Eval(proto_tv->interp, buf); sprintf(buf, "label %s.ddl -text \"Deadlocks: %i\" -bg orange", keypath, n_bads[T_DEADLOCK]); Tcl_Eval(proto_tv->interp, buf); sprintf(buf, "label %s.abr -text \"Aborts: %i\" -bg green", keypath, n_bads[T_ABORT]); Tcl_Eval(proto_tv->interp, buf); sprintf(buf, "label %s.leafs -text \" Branches: %i\" ", keypath, nbr_of_leafs); Tcl_Eval(proto_tv->interp, buf); sprintf(buf, "pack %s.asv %s.ddl %s.abr %s.leafs -side left", keypath, keypath, keypath, keypath); Tcl_Eval(proto_tv->interp, buf); } void add_trans(treeview *tv, int org, int dest, int label, int pid, int toss, int type, char *str) { node *allnodes; node_row *noderows; node *parent; int depth, qtyn, i, *j; allnodes = tv->allnodes; noderows = tv->noderows; do { if(tv->qtynodes >= tv->csznodes) { tv->csznodes += 16; allnodes = tv->allnodes = realloc(tv->allnodes, tv->csznodes*sizeof(node)); } if(dest > tv->qtynodes+1) tv->qtynodes++; } while(tv->qtynodes+1 < dest); allnodes[tv->qtynodes].parent = org; allnodes[tv->qtynodes].label = label; allnodes[tv->qtynodes].pid = pid; if (pid >= tv->n_pids) tv->n_pids++; allnodes[tv->qtynodes].toss = toss; CHKPT(90); add_str(tv->bks, tv->bksz, strdup(str), &allnodes[tv->qtynodes].hk, &allnodes[tv->qtynodes].dp); CHKPT(107); allnodes[tv->qtynodes].lchild = 0; allnodes[tv->qtynodes].rsib = 0; switch(type) { case(T_ASSERTVIO): allnodes[tv->qtynodes].hlflags = HLF_ASSERTVIO; break; case(T_DEADLOCK): allnodes[tv->qtynodes].hlflags = HLF_DEADLOCK; break; case(T_ABORT): allnodes[tv->qtynodes].hlflags = HLF_ABORT; break; default: allnodes[tv->qtynodes].hlflags = 0; } j = &(allnodes[org].lchild); while(*j) { j = &(allnodes[*j].rsib); } *j = dest; depth = allnodes[tv->qtynodes].depth = allnodes[org].depth+1; if(tv->qtynrows > depth) { allnodes[tv->qtynodes].row = depth; } else { tv->qtynrows = depth; if(tv->qtynrows >= tv->csznrows) { tv->csznrows += 16; noderows = tv->noderows = realloc(noderows, tv->csznrows*sizeof(node_row)); } CHKPT(108); noderows[depth].depth = depth; CHKPT(109); allnodes[tv->qtynodes].row = depth; noderows[depth].csznodes = 16; noderows[depth].qtynodes = 0; noderows[depth].nodes = (int *) malloc(noderows[depth].csznodes*sizeof(int *)); tv->qtynrows++; } qtyn = noderows[depth].qtynodes; if(qtyn >= noderows[depth].csznodes) { noderows[depth].csznodes += 16; noderows[depth].nodes = realloc(noderows[depth].nodes, noderows[depth].csznodes*sizeof(int)); } noderows[depth].nodes[qtyn] = tv->qtynodes; noderows[depth].qtynodes++; tv->qtynodes++; } int tree_paint_it(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { treeview *tv = (treeview *) cd; tv->flags |= F_UPDATE; tree_paint(cd); tv->flags &= ~F_UPDATE; return TCL_OK; } int font_size(int x) { if(x < 6) return 0; if(x < 21) return x; if(x < 24) return 20; if(x < 27) return x; if(x < 30) return 26; if(x < 33) return 30; if(x < 35) return x; if(x == 35) return 34; if(x < 40) return 36; if(x < 50) return 40; if(x < 60) return 50; if(x >= 60) return 60; } int tree_center(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { int x, y; treeview *tv; tv = (treeview *) cd; if(argc >= 3) { x = atoi(argv[1]); y = atoi(argv[2]); tv->origin_x += (tv->xsz/2-x); tv->origin_y += (tv->ysz/2-y); XWarpPointer(tv->disp, 0, Tk_WindowId(tv->tree_window), 0, 0, 0, 0, tv->xsz/2, tv->ysz/2); tree_paint(cd); } return TCL_OK; } int tree_zoom_examine(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char str[256]; int fsize; float scf; treeview *tv; tv = (treeview *) cd; scf = 15 / tv->dot_width; tv->dot_width = 15; tv->row_space *= scf; tv->index_space *= scf; tv->img_width *= scf; tv->origin_x = (tv->origin_x - tv->xsz/2)*scf + tv->xsz/2; tv->origin_y = (tv->origin_y - tv->ysz/2)*scf + tv->ysz/2; fsize = font_size(tv->dot_width/1.2); if (fsize) { sprintf(str, "-*-courier-*-r-*-*-%i-*-*-*-*-*-*-*", fsize); XSetFont(tv->disp, tv->tree_gc, tv->f = XLoadFont(tv->disp, str)); } else { tv->flags &= ~F_SHOWCOMMENTS; } tv->flags &= ~F_UPDATE; tree_paint(cd); return TCL_OK; } int tree_zoom_overall(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char str[256]; int fsize; float scf; treeview *tv; tv = (treeview *) cd; scf = 1 / tv->dot_width; tv->dot_width = 1; tv->row_space *= scf; tv->index_space *= scf; tv->img_width *= scf; tv->origin_x = tv->xsz/2; tv->origin_y = 100; fsize = font_size(tv->dot_width/1.2); if (fsize) { sprintf(str, "-*-courier-*-r-*-*-%i-*-*-*-*-*-*-*", fsize); XSetFont(tv->disp, tv->tree_gc, tv->f = XLoadFont(tv->disp, str)); } else { tv->flags &= ~F_SHOWCOMMENTS; } tv->flags &= ~F_UPDATE; tree_paint(cd); return TCL_OK; } int tree_zoom_in(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char str[256]; int fsize; treeview *tv; tv = (treeview *) cd; tv->dot_width *= 1.1; tv->row_space *= 1.1; tv->index_space *= 1.1; tv->img_width *= 1.1; tv->origin_x = (tv->origin_x - tv->xsz/2)*1.1 + tv->xsz/2; tv->origin_y = (tv->origin_y - tv->ysz/2)*1.1 + tv->ysz/2; fsize = font_size(tv->dot_width/1.2); if (fsize) { sprintf(str, "-*-courier-*-r-*-*-%i-*-*-*-*-*-*-*", fsize); XSetFont(tv->disp, tv->tree_gc, tv->f = XLoadFont(tv->disp, str)); } else { tv->flags &= ~F_SHOWCOMMENTS; } tv->flags &= ~F_UPDATE; tree_paint(cd); return TCL_OK; } int tree_zoom_out(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char str[256]; int fsize; treeview *tv; tv = (treeview *) cd; tv->dot_width /= 1.1; tv->row_space /= 1.1; tv->index_space /= 1.1; tv->img_width /= 1.1; tv->origin_x = (tv->origin_x - tv->xsz/2)/1.1 + tv->xsz/2; tv->origin_y = (tv->origin_y - tv->ysz/2)/1.1 + tv->ysz/2; fsize = font_size(tv->dot_width/1.2); if (fsize) { sprintf(str, "-*-courier-*-r-*-*-%i-*-*-*-*-*-*-*", fsize); XSetFont(tv->disp, tv->tree_gc, tv->f = XLoadFont(tv->disp, str)); } else { tv->flags &= ~F_SHOWCOMMENTS; } tv->flags &= ~F_UPDATE; tree_paint(cd); return TCL_OK; } int tree_set_x(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char buf[256]; treeview *tv; int x; tv = (treeview *) cd; x = atol(argv[1]); if ((50000-x) > 0) x=50; else x=-50; tv->origin_x += x; tv->flags &= ~F_UPDATE; tree_paint(cd); return TCL_OK; } int tree_set_y(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char buf[256]; treeview *tv; int y; tv = (treeview *) cd; y = atol(argv[1]); if ((50000-y) > 0) y=50; else y=-50; tv->origin_y += y; tv->flags &= ~F_UPDATE; tree_paint(cd); return TCL_OK; } int tree_move_left(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { treeview *tv; tv = (treeview *) cd; tv->origin_x += 50; tree_paint(cd); return TCL_OK; } int tree_move_right(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { treeview *tv; tv = (treeview *) cd; tv->origin_x -= 50; tree_paint(cd); return TCL_OK; } int tree_move_up(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { treeview *tv; tv = (treeview *) cd; tv->origin_y += 50; tree_paint(cd); return TCL_OK; } int tree_move_down(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { treeview *tv; tv = (treeview *) cd; tv->origin_y -= 50; tree_paint(cd); return TCL_OK; } int tree_configure(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { treeview *tv; tv = (treeview *) cd; if(!strcmp(argv[1], "showcomments") && (argc == 2)) { tv->flags |= F_SHOWCOMMENTS; tree_paint(cd); return TCL_OK; } else if(!strcmp(argv[1], "hidecomments") && (argc == 2)) { tv->flags &= ~F_SHOWCOMMENTS; tree_paint(cd); return TCL_OK; } else if(!strcmp(argv[1], "togglecomments") && (argc == 2)) { tv->flags ^= F_SHOWCOMMENTS; tree_paint(cd); return TCL_OK; } else if(!strcmp(argv[1], "size") && (argc == 4)) { tv->xsz = atol(argv[2]); tv->ysz = atol(argv[3]); Tk_ResizeWindow(tv->tree_window, tv->xsz, tv->ysz); return TCL_OK; } else return TCL_ERROR; } long int fetch_color(Tcl_Interp *interp, char *colorname, Tk_Window tkwin) { XColor *color; color = Tk_GetColor(interp, tkwin, Tk_GetUid(colorname)); return color->pixel; } void cache_colors(Tcl_Interp *interp, treeview *tv) { tv->colors[C_BLACK] = fetch_color(interp, "black", tv->tree_window); tv->colors[C_WHITE] = fetch_color(interp, "white", tv->tree_window); tv->colors[C_NODE] = fetch_color(interp, "gray", tv->tree_window); tv->colors[C_NODE_HIGHLIGHT] = fetch_color(interp, "green", tv->tree_window); tv->colors[C_NODE_OVER] = fetch_color(interp, "cyan", tv->tree_window); tv->colors[C_FILTER] = fetch_color(interp, "black", tv->tree_window); tv->colors[C_TRACE] = fetch_color(interp, "blue", tv->tree_window); tv->colors[C_RED] = fetch_color(interp, "red", tv->tree_window); tv->colors[C_GREEN] = fetch_color(interp, "green", tv->tree_window); tv->colors[C_BLUE] = fetch_color(interp, "blue", tv->tree_window); tv->colors[C_ASSERTVIO] = fetch_color(interp, "red", tv->tree_window); tv->colors[C_DEADLOCK] = fetch_color(interp, "orange", tv->tree_window); tv->colors[C_ABORT] = fetch_color(interp, "green", tv->tree_window); } static void tree_repaint(ClientData tkcd, XEvent *ev) { treeview *tv = (treeview *) tkcd; tv->flags &= ~F_UPDATE; tree_paint(tkcd); } static void tree_paint(ClientData tkcd) { char str[256]; char *prune_warn = "Warning: now in pruned state (not shown)"; char temp_string[17]; XGCValues xgcv; node *allnodes; node_row *noderows; char *lbl; int drawdir, filtered, hk, dp; int i, j; int x, dx, y, py; int a, b; int stable_state; int cx, cy, circle_width; Drawable d; treeview *tv; int k; CHKPT(1); tv = (treeview *) tkcd; d = Tk_WindowId(tv->tree_window); temp_string[16]=0; Tcl_Eval(tv->interp, "global stable_state"); XGetGCValues(tv->disp, tv->tree_gc, GCForeground|GCBackground, &xgcv); allnodes = tv->allnodes; noderows = tv->noderows; drawdir = 1; if(!(tv->flags & F_UPDATE)) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_WHITE]); XFillRectangle(tv->disp, d, tv->tree_gc, 0, 0, tv->xsz, tv->ysz); sprintf(str, "%s configure -text \"Move the pointer over a node to see which state it represents.\"", tv->status_bar, str); Tcl_Eval(tv->interp, str); } circle_width = (2 * tv->dot_width > 16) ? (2 * tv->dot_width) : 16; cy = cx = (circle_width - tv->dot_width) / 2; for(i = 0; i < tv->qtynrows; i++) { CHKPT(5); if(allnodes[noderows[i].nodes[0]].parent>allnodes[noderows[i].nodes[noderows[i].qtynodes-1]].parent) { drawdir = !drawdir; } CHKPT(6); noderows[i].direction = drawdir?1:-1; CHKPT(7); for(j = 0; j < noderows[i].qtynodes; j++) { hk = allnodes[noderows[i].nodes[j]].hk; dp = allnodes[noderows[i].nodes[j]].dp; filtered = get_flags(tv->bks, tv->bksz, hk, dp) && tv->pidhi[allnodes[noderows[i].nodes[j]].pid]; if((tv->flags & F_CLEARTRACE) && noderows[i].nodes[j]) { allnodes[noderows[i].nodes[j]].hlflags &= ~HLF_TRACED; } find_coords_by_node(tv, i, j, &x, &y); CHKPT(8); allnodes[noderows[i].nodes[j]].x = x; allnodes[noderows[i].nodes[j]].y = y; py = allnodes[allnodes[noderows[i].nodes[j]].parent].y; if((x < tv->xsz)&&(x >= 0)&&(py < tv->ysz)&&(y >= 0)) { CHKPT(9); allnodes[noderows[i].nodes[j]].hlflags &= ~HLF_HIGHLIT; XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_NODE]); if(filtered) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_FILTER]); } if((allnodes[allnodes[noderows[i].nodes[j]].parent].hlflags & HLF_HIGHLIT)||(noderows[i].nodes[j] == tv->clicked_node)) { allnodes[noderows[i].nodes[j]].hlflags |= HLF_HIGHLIT; XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_NODE_HIGHLIGHT]); } CHKPT(10); Tcl_GetBoolean(tv->interp, Tcl_GetVar(tv->interp, "stable_state", 0), &stable_state); CHKPT(11); if(allnodes[noderows[i].nodes[j]].hlflags & HLF_TRACEDTO) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_TRACE]); if((noderows[i].nodes[j] != tv->current_state) || stable_state) allnodes[noderows[i].nodes[j]].hlflags |= HLF_TRACEDTHROUGH; else allnodes[noderows[i].nodes[j]].hlflags &= ~HLF_TRACEDTHROUGH; } CHKPT(12); XDrawLine(tv->disp, d, tv->tree_gc, x+tv->dot_width/2, y+tv->dot_width/2, allnodes[allnodes[noderows[i].nodes[j]].parent].x+tv->dot_width/2, allnodes[allnodes[noderows[i].nodes[j]].parent].y+tv->dot_width/2); if((noderows[i].nodes[j] == tv->current_state) && !stable_state) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_NODE]); if(filtered) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_FILTER]); } if((allnodes[allnodes[noderows[i].nodes[j]].parent].hlflags & HLF_HIGHLIT)||(noderows[i].nodes[j] == tv->clicked_node)) { allnodes[noderows[i].nodes[j]].hlflags |= HLF_HIGHLIT; XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_NODE_HIGHLIGHT]); } } CHKPT(13); if(allnodes[noderows[i].nodes[j]].hlflags & HLF_ASSERTVIO) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_ASSERTVIO]); XDrawArc(tv->disp, d, tv->tree_gc, x - cx, y - cy, circle_width, circle_width, 0, 360*64); XDrawArc(tv->disp, d, tv->tree_gc, x - cx + 1, y - cy + 1, circle_width - 2, circle_width - 2, 0, 360*64); } else if(allnodes[noderows[i].nodes[j]].hlflags & HLF_DEADLOCK) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_DEADLOCK]); XDrawArc(tv->disp, d, tv->tree_gc, x - cx, y - cy, circle_width, circle_width, 0, 360*64); XDrawArc(tv->disp, d, tv->tree_gc, x - cx + 1, y - cy + 1, circle_width - 2, circle_width - 2, 0, 360*64); } else if(allnodes[noderows[i].nodes[j]].hlflags & HLF_ABORT) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_ABORT]); XDrawArc(tv->disp, d, tv->tree_gc, x - cx, y - cy, circle_width, circle_width, 0, 360*64); XDrawArc(tv->disp, d, tv->tree_gc, x - cx + 1, y - cy + 1, circle_width - 2, circle_width - 2, 0, 360*64); } if(allnodes[noderows[i].nodes[j]].hlflags & HLF_TRACEDTHROUGH) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_TRACE]); } CHKPT(14); XFillArc(tv->disp, d, tv->tree_gc, x, y, tv->dot_width, tv->dot_width, 0, 360*64); CHKPT(15); if(tv->flags & F_SHOWCOMMENTS) { lbl = get_str(tv->bks, tv->bksz, allnodes[noderows[i].nodes[j]].hk, allnodes[noderows[i].nodes[j]].dp); CHKPT(18); if (strlen(lbl) < 18 ) XDrawString(tv->disp, d, tv->tree_gc, x-3*strlen(lbl), y, lbl, strlen(lbl)); else { for (k=0; (k*16) <= strlen(lbl); k++) { strncpy(temp_string,(char *)lbl+(k*16),16); XDrawString(tv->disp, d, tv->tree_gc, x-3*16, y-(2-k)*(tv->dot_width), temp_string, strlen(temp_string)); } } } CHKPT(16); if((tv->flags & F_IN_PRUNED) && (noderows[i].nodes[j] == tv->current_state)) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_RED]); XDrawString(tv->disp, d, tv->tree_gc, x-3*strlen(prune_warn), y+2*(tv->dot_width), prune_warn, strlen(prune_warn)); } } } } CHKPT(17); XSetForeground(tv->disp, tv->tree_gc, xgcv.foreground); XSetBackground(tv->disp, tv->tree_gc, xgcv.background); tv->flags &= ~F_CLEARTRACE; CHKPT(170); } void find_coords_by_node(treeview *tv, int row, int idx, int *x, int *y) { (*y) = tv->origin_y + row*tv->row_space; (*x) = tv->origin_x - tv->noderows[row].direction*tv->index_space*((tv->noderows[row].qtynodes-1)/2 - idx); } int find_node_by_coords(treeview *tv, int x, int y, int *realx, int *realy) { int row, idx; row = (y - tv->origin_y + tv->row_space/2)/tv->row_space; if((row < 0)||(row >= tv->qtynrows)) return -1; idx = (tv->noderows[row].qtynodes-1)/2 - ((tv->origin_x - x)/(tv->noderows[row].direction) - tv->index_space/2) / tv->index_space; if((idx < 0)||(idx >= tv->noderows[row].qtynodes)) return -1; find_coords_by_node(tv, row, idx, realx, realy); return tv->noderows[row].nodes[idx]; } static void tree_mouse_moved(ClientData tkcd, XEvent *ev) { XPointerMovedEvent *mouse; int n, x, y; char str[256], buf[256], *text; Drawable d; treeview *tv; XGCValues xgcv; CHKPT(400); tv = (treeview *) tkcd; mouse = (XPointerMovedEvent *) ev; d = Tk_WindowId(tv->tree_window); XGetGCValues(tv->disp, tv->tree_gc, GCForeground|GCBackground, &xgcv); CHKPT(410); n = find_node_by_coords(tv, mouse->x, mouse->y, &x, &y); CHKPT(412); if(n != tv->lastnode) { CHKPT(415); if(n+1) { sprintf(str, "%s (pid = %i, toss = %i, state = %i)", get_str(tv->bks, tv->bksz, tv->allnodes[n].hk, tv->allnodes[n].dp), tv->allnodes[n].pid, tv->allnodes[n].toss, n); } else sprintf(str, "Move the pointer over a node to see which state it represents."); CHKPT(420); if(tv->allnodes[tv->lastnode].hlflags & HLF_TRACEDTHROUGH) { CHKPT(421); XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_TRACE]); } else if(tv->allnodes[tv->lastnode].hlflags & HLF_ASSERTVIO) { CHKPT(422); XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_ASSERTVIO]); } else if(tv->allnodes[tv->lastnode].hlflags & HLF_DEADLOCK) { CHKPT(423); XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_DEADLOCK]); } else if(tv->allnodes[tv->lastnode].hlflags & HLF_ABORT) { CHKPT(424); XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_ABORT]); } else if(tv->allnodes[tv->lastnode].hlflags & HLF_HIGHLIT) { CHKPT(425); XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_NODE_HIGHLIGHT]); } else { CHKPT(428); XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_NODE]); } CHKPT(430); XFillArc(tv->disp, d, tv->tree_gc, tv->allnodes[tv->lastnode].x, tv->allnodes[tv->lastnode].y, tv->dot_width, tv->dot_width, 0, 360*64); CHKPT(440); if(n+1) { XSetForeground(tv->disp, tv->tree_gc, tv->colors[C_NODE_OVER]); XFillArc(tv->disp, d, tv->tree_gc, x, y, tv->dot_width, tv->dot_width, 0, 360*64); } CHKPT(450); sprintf(buf, "%s configure -text \"%s\"", tv->status_bar, str); Tcl_Eval(tv->interp, buf); CHKPT(460); if (n+1) tv->lastnode = n; } CHKPT(490); XSetForeground(tv->disp, tv->tree_gc, xgcv.foreground); XSetBackground(tv->disp, tv->tree_gc, xgcv.background); CHKPT(499); } static void tree_button_pressed(ClientData tkcd, XEvent *ev) { XButtonEvent *mouse; treeview *tv; char cmdbuf[256]; int old_clicked, i, j, x, y, ox, oy; tv = (treeview *) tkcd; mouse = (XButtonEvent *) ev; if(mouse->button == 1) { sprintf(cmdbuf, "on_tree_lclick %i %i %i", find_node_by_coords(tv, mouse->x, mouse->y, &x, &y), mouse->x, mouse->y); Tcl_Eval(tv->interp, cmdbuf); } else if(mouse->button == 2) { sprintf(cmdbuf, "on_tree_mclick %i %i %i", find_node_by_coords(tv, mouse->x, mouse->y, &x, &y), mouse->x, mouse->y); Tcl_Eval(tv->interp, cmdbuf); } else if(mouse->button == 3) { sprintf(cmdbuf, "on_tree_rclick %i %i %i", find_node_by_coords(tv, mouse->x, mouse->y, &x, &y), mouse->x, mouse->y); Tcl_Eval(tv->interp, cmdbuf); } } int tree_trace_to_state(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char buf[256], si[16]; stack s; node *n; treeview *tv; int state, state_bak, i; tv = (treeview *) cd; if(tv->flags & F_SIMULATORBUSY) { return TCL_OK; } if((argc >= 2) && (atol(argv[1]) >= 0)) { s = make_stack(); state_bak = state = atol(argv[1]); while(state && ((state != tv->current_state)|| (tv->flags & F_IN_PRUNED))) { n = &(tv->allnodes[state]); stack_push(s, n); state = n->parent; } Tcl_Eval(tv->interp, "global event_cnt simul_pid"); if(!state) { state = tv->current_state; while(state && (state != state_bak)) { n = &(tv->allnodes[state]); state = n->parent; } if (state != state_bak) { Tcl_Eval(tv->interp, "reset_pc;\r							cut_tail;\r                                                        set simul_pid 0;\r							set event_cnt 0;\r							draw_pc 0;"); } else { Tcl_Eval(tv->interp, "reset_pc"); } tv->current_state = 0; } tv->flags |= F_SIMULATORBUSY; while(*s) { stack_pop(s, (void **) &n); sprintf(buf, "gdb_execute %i cont %i ", n->pid, n->toss); Tcl_Eval(tv->interp, buf); } tv->flags &= ~F_SIMULATORBUSY; free(s); return TCL_OK; } else return TCL_ERROR; } int tree_transition(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { treeview *tv; int pid, toss; int os, s, found; tv = (treeview *) cd; if((argc > 3) && !strcmp("do", argv[1])) { if(tv->flags & F_IN_PRUNED) return TCL_OK; pid = atol(argv[2]); toss = atol(argv[3]); s = tv->allnodes[tv->current_state].lchild; found = 0; while(s && !found) { if((tv->allnodes[s].pid == pid)&&(tv->allnodes[s].toss == toss)) found = 1; os = s; s = tv->allnodes[s].rsib; } if(!found) { tv->flags |= F_IN_PRUNED; } else { tv->current_state = os; tv->allnodes[os].hlflags |= HLF_TRACEDTO; } tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; return TCL_OK; } else if((argc > 1) && !strcmp("clear", argv[1])) { tv->current_state = 0; tv->flags |= F_CLEARTRACE; tv->flags &= ~F_IN_PRUNED; tree_paint(tv); tv->flags &= ~F_CLEARTRACE; return TCL_OK; } else { return TCL_ERROR; } } int do_regexp(Tcl_Interp *interp, char *re, char *str) { char buf[256]; sprintf(buf, "regexp \"%s\" \"%s\"", re, str); Tcl_Eval(interp, buf); return (interp->result[0] & 1); } int tree_filter(ClientData cd, Tcl_Interp *interp, int argc, char **argv) { char buf[256], *str; vector *v; strbucket *s; int i, j; int hk, dp; int pid; int old_clicked; treeview *tv; tv = (treeview *) cd; if((argc > 1) && !strcmp(argv[1], "clear")) { for(i = 0; i <= tv->n_pids; i++) tv->pidhi[i] = 0; for(i = 0; i < 1<<(tv->bksz); i++) { for(s = &tv->bks[i]; s; s = s->c) s->flags = 0; } tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; tv->flags &= ~F_CLEARTRACE; return TCL_OK; } else if((argc > 2) && !strcmp(argv[1], "use")) { get_hkdp(tv->bks, tv->bksz, argv[2], &hk, &dp); set_flags(tv->bks, tv->bksz, hk, dp, F_SHI); sprintf(buf, "%s paint", tv->lbl_mbx); tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; tv->flags &= ~F_CLEARTRACE; return TCL_OK; } else if((argc > 2) && !strcmp(argv[1], "unuse")) { get_hkdp(tv->bks, tv->bksz, argv[2], &hk, &dp); set_flags(tv->bks, tv->bksz, hk, dp, 0); sprintf(buf, "%s paint", tv->lbl_mbx); tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; tv->flags &= ~F_CLEARTRACE; return TCL_OK; } else if((argc > 2) && !strcmp(argv[1], "puse")) { pid = atol(argv[2]); tv->pidhi[pid] = 1; sprintf(buf, "%s paint", tv->lbl_mbx); Tcl_Eval(interp, buf); tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; tv->flags &= ~F_CLEARTRACE; return TCL_OK; } else if((argc > 2) && !strcmp(argv[1], "punuse")) { pid = atol(argv[2]); tv->pidhi[pid] = 0; sprintf(buf, "%s paint", tv->lbl_mbx); tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; tv->flags &= ~F_CLEARTRACE; return TCL_OK; } else if((argc > 2) && !strcmp(argv[1], "successors")) { old_clicked = tv->clicked_node; tv->clicked_node = atol(argv[2]); if(tv->clicked_node != old_clicked) { for(i = 0; i < tv->qtynrows; i++) { for(j = 0; j < tv->noderows[i].qtynodes; j++) { tv->allnodes[tv->noderows[i].nodes[j]].hlflags &= ~HLF_HIGHLIT; } } tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; tv->flags &= ~F_CLEARTRACE; } return TCL_OK; } else if((argc > 2) && !strcmp(argv[1], "regexp")) { for(i = 0; i < (1<<tv->bksz); i++) { s = &tv->bks[i]; while(s) { if(s->s) if(do_regexp(interp, argv[2], s->s)) { sprintf(buf, "%s select \"%s\" -quiet", tv->lbl_mbx, s->s); Tcl_Eval(interp, buf); } s = s->c; } sprintf(buf, "%s paint", tv->lbl_mbx); Tcl_Eval(interp, buf); } for(i = 0; i < tv->qtynodes; i++) { if(do_regexp(interp, argv[2], get_str(tv->bks, tv->bksz, tv->allnodes[i].hk, tv->allnodes[i].dp))) set_flags(tv->bks, tv->bksz, tv->allnodes[i].hk, tv->allnodes[i].dp, F_SHI); } tv->flags |= F_UPDATE; tree_paint(tv); tv->flags &= ~F_UPDATE; tv->flags &= ~F_CLEARTRACE; return TCL_OK; } else return TCL_ERROR; }