
#define VS_version "VeriSoft Version 2.0.9"
#include <stdio.h>
#include <errno.h>
#include <malloc.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include <sys/msg.h>
#include <sys/stat.h>
#include "macros.h"
#include "getkey.h"
#include "verisoft-semdef.h"
#include "shmdef.h"
#include "msgdef.h"
extern int errno;
#ifdef RANDOM_MEMORY_LESS_SEARCH
extern int VS_external_next_trans(int); extern void VS_evaluate_fitness();
#endif
#define MAXSIZE 4000
#define MAXSEMID 20
#define MAXSHMID 20
#define MAXMSQID 20
#define MAXPROC 20
#define MAXPROC_CHAR 3
#define BASIC_SIZE 300000
#define OPERATION_STACK_SIZE 200
#define REPORT_STATE_UNIT 5000
#define MAXLINE 256
#define MAX_PRINT_MSG_LEN 64
#define MAX_FILENAME 100
#define SEMAPHORE_WAIT 0
#define SEMAPHORE_SIGNAL 1
#define IS_QUEUE_FULL 2
#define IS_QUEUE_EMPTY 3
#define SEND_TO_QUEUE 4
#define RCV_FROM_QUEUE 5
#define SYNCHRO_READ_FILE 6
#define SYNCHRO_WRITE_FILE 7
#define SYNCHRO_CREATE_LOCKED_FILE 8
#define SYNCHRO_REMOVE_FILE 9
#define NUMBER_OF_TYPES_OF_COM_OBJ 10
#define ASSERT_VIOLATION 100
#define EXIT 101
#define DIVERGENCE 102
#define TOSS 103
#define ABORT 104
#define PRINT 105
typedef struct State { char sleep_proc[MAXPROC_CHAR]; int number_of_succ; int first_next_trans; } State; typedef struct Trans { int label; int previous_trans; int successor_state; int process_id; int toss_choice; int type; } Trans; typedef struct El_dfs_stack { int trans; int remaining; } El_dfs_stack; typedef struct Operation_proc_elem { int proc; int next; } Operation_proc_elem; typedef struct Operation_obj_elem { int obj; int index; int first_Operation_proc_elem; int next; } Operation_obj_elem; typedef union { int val; struct semid_ds *buf; ushort *array; } Semun; static void VS_wrapup(); static void VS_timeout(int); static void VS_init(); static void VS_clean_system(); static int VS_print_next_sys_call(int, int); static int VS_print_msg_of_previous_sys_call(int); static void VS_produce_seqflow_file(int); static void VS_produce_error_path(); extern void VS_pause(); static void VS_safe_string_copy_into_VS_buffer(char *); extern int VS_fork(); extern int VS_semget(key_t, int, int); extern int VS_shmget(key_t, int, int); extern int VS_semctl(int, int, int, Semun); extern int VS_semop(int, struct sembuf *, int); extern int VS_semcreate(int); extern void VS_semremove(int); extern int VS_shmcreate(int); extern void VS_shmremove(int); extern void VS_sleep(unsigned); extern void VS_dont_printf(char *); extern void VS_exit(int); extern void VS_semwait(int, int, int); extern void VS_semsignal(int, int, int); extern void VS_assert_viol(); extern void VS_abort_viol(); extern int VS_toss(int); extern void VS_print(char *); extern int VS_get_bounded_queue(int); extern void VS_remove_queue(int); extern int VS_is_queue_full(int, int); extern int VS_is_queue_empty(int, int); extern void VS_send_to_queue(int, int, char *); extern char *VS_rcv_from_queue(int, int); extern char *VS_rcv_from_queue_without_deadlock(int, int); extern void VS_synchro_read_file(char *); extern void VS_synchro_write_file(char *); extern void VS_synchro_create_locked_file(char *); extern void VS_synchro_remove_file(char *); static char *VS_emalloc(unsigned); static char *VS_erealloc(char *, unsigned, unsigned); static int msqid_to_id(int); static int semid_to_id(int); static void scheduler_semwait(int, int, int); static void VS_pause_semwait(int, int, int); static char *print_op_type(int); static void execute_trans(int); static void Srand(unsigned int); extern long VS_Rand(); static void VS_process_system_file(); static void create_list_of_proc(int, int, int, int); static int list_of_proc(int, int, int); static void check(int, int, int, int); static void update_sleep_sets(int, int, int); static void process_init_path();
#ifndef SIMUL
static void VS_close_sss(int); static void VS_print_trans_in_sss_pre(int); static void VS_print_trans_in_sss_post();
#endif
static void VS_scheduler(); static int VS_init_done=0; static int VS_first_fork_done=0; static int VS_count_proc; static int VS_my_pid; static int VS_shmid, VS_semid; static int VS_nproc; static int VS_max_depth; static int VS_depth_incr; static int VS_livelock_limit; static int VS_ignore_deadlock; static char *VS_init_path=0; static int VS_divergence_limit; static int VS_stop_at_error; static int VS_stop_at_state; static int VS_save_state_space; static long VS_max_sss; static long size_of_sss=0; static int type_of_sys_call; static long Seed; static int sigusr2; static int *VS_shm; static int *VS_array_semid; static int *VS_nbr_of_semid_used; static int *VS_array_shmid; static int *VS_nbr_of_shmid_used; static int *VS_array_msqid; static int *VS_nbr_of_msqid_used; static int *VS_array_pid; static char *VS_buffer_for_message; static char *VS_array_filename; static int VS_nbr_of_msg_in_msqid[MAXMSQID]; static struct Trans *trans_stack; static struct State *state_stack; static struct El_dfs_stack *dfs_stack; static int number_of_states, number_of_trans; static int dfs_stpt; static int trans_stack_size, state_stack_size; static int dfs_stack_size; static int VS_length_of_init_path=0; static int VS_error_count=1; static struct Operation_proc_elem *Operation_proc_stack; static struct Operation_obj_elem *Operation_obj_stack; static int VS_operations[NUMBER_OF_TYPES_OF_COM_OBJ]; static int Operation_proc_stack_size, Operation_obj_stack_size; static int Operation_proc_stpt; static int Operation_obj_stpt; static FILE *fo; static FILE *fo_VS; static FILE *fo_init_path; static FILE *fo_sss;
#ifdef SS
static FILE *fo_ss;
#endif
void VS_wrapup() { int i,j; signal(SIGALRM, SIG_IGN); printf("\n"); printf("Number of states: %d\n", number_of_states);
#ifdef VS_DEBUG
for(i=0;i!=number_of_states;i++) { j=((trans_stack+((state_stack+i)->first_next_trans))->successor_state == 0) ? 1 : 0; printf("\t state %d: number_of_succ= %d, first_next_trans= %d, leaf? %d\n", i, (state_stack+i)->number_of_succ, (state_stack+i)->first_next_trans, j); printf("processes in sleep set: "); for (j=1;j<=VS_nproc;j++) { if (bis_set((state_stack+i)->sleep_proc,j)) printf("%d, ",j); }; printf("\n"); };
#endif
printf("Number of transitions: %d\n", number_of_trans);
#ifdef VS_DEBUG
for(i=0;i!=number_of_trans;i++) { printf("\t trans %d: successor_state= %d, process_id= %d, toss_choice= %d\n", (trans_stack+i)->label, (trans_stack+i)->successor_state, (trans_stack+i)->process_id, (trans_stack+i)->toss_choice); };
#endif
#ifdef SS
fprintf(fo_ss, "\n#end\n");
#endif
#ifdef EDV
if (!(fo_sss=fopen("sss-state.VS","w"))) { fprintf(stderr,"VeriSoft Error: cannot create sss-state.VS !\n"); } else { fprintf(fo_sss,"id\tnumber_of_succ\n"); fprintf(fo_sss,"i\ti\n"); for(i=0;i<=number_of_states;i++) { fprintf(fo_sss,"%d\t%d\n", i, (state_stack+i)->number_of_succ); }; };
#endif
printf("\n%s\n", VS_version); for(i=0;i<VS_nproc;i++) { if (*(VS_array_pid+i)) { if (sigusr2) kill(*(VS_array_pid+i), SIGUSR2); else kill(*(VS_array_pid+i), SIGKILL); } } if (wait(NULL)==-1) fprintf(stderr, "VeriSoft Error: error in wait \n"); for(i=0;i<*VS_nbr_of_semid_used;i++) semremove(*(VS_array_semid+i)); for(i=0;i<*VS_nbr_of_shmid_used;i++) shmremove(*(VS_array_shmid+i)); for(i=0;i<*VS_nbr_of_msqid_used;i++) remove_queue(*(VS_array_msqid+i)); semremove(VS_semid); shmremove(VS_shmid); exit(0); } void VS_timeout(sig) int sig; { int pid_error; printf("timeout expired!\n"); signal(sig, SIG_IGN); if (dfs_stpt) { pid_error=(trans_stack+((dfs_stack+dfs_stpt-1)->trans))->process_id; printf("\ndivergence in Process_%d detected at depth %d !!!\n", pid_error, dfs_stpt); VS_produce_error_path(); printf("It would not be safe to continue the search after a divergence...\n"); } else { printf("\nthe initial global state is unreachable!\n"); printf("either the number of processes speficied in ./system_file.VS is incorrect,\n"); printf("or there is a divergence before the initial state...\n"); }; VS_wrapup(); } void VS_init() { struct shmid_ds VS_shmid_ds; Semun VS_arg; int pid; int i; int very_first_time=0; if ((VS_shmid = shmget(getkey(), MAXSIZE, IPC_CREAT | 0600)) == -1) { fprintf(stderr, "Error %d in shmget: %s\n",errno,sys_errlist[errno]); exit(errno); }; if ((int)(VS_shm = (int *)shmat(VS_shmid,0,0)) == -1) { fprintf(stderr, "Error %d in shmat: %s\n",errno,sys_errlist[errno]); exit(errno); }; VS_array_semid=VS_shm; VS_nbr_of_semid_used=VS_array_semid+MAXSEMID; *VS_nbr_of_semid_used=0; VS_array_shmid=VS_nbr_of_semid_used+1; VS_nbr_of_shmid_used=VS_array_shmid+MAXSHMID; *VS_nbr_of_shmid_used=0; VS_array_msqid=VS_nbr_of_shmid_used+1; VS_nbr_of_msqid_used=VS_array_msqid+MAXMSQID; *VS_nbr_of_msqid_used=0; VS_array_pid=VS_nbr_of_msqid_used+1; memset((char *)VS_array_pid, 0, MAXPROC*sizeof(int)); VS_shm=VS_array_pid+MAXPROC; VS_buffer_for_message=(char *)VS_shm+(4*MAXPROC)+4; VS_array_filename=(char *)VS_buffer_for_message+MAX_PRINT_MSG_LEN; pid=getpid(); if (shmctl(VS_shmid,IPC_STAT,&VS_shmid_ds) == -1) { fprintf(stderr, "Error %d in shmctl: %s\n",errno,sys_errlist[errno]); exit(errno); }; if (pid == (int)(VS_shmid_ds.shm_cpid)) { very_first_time=1; VS_process_system_file(); } else { VS_nproc=*VS_shm; }; if ((VS_semid = semget(getkey(), VS_nproc+1, IPC_CREAT | 0600)) == -1) { fprintf(stderr, "Error %d in semget: %s\n",errno,sys_errlist[errno]); exit(errno); }; VS_init_done=1; VS_count_proc=1; VS_my_pid=1; *VS_array_pid=pid; if (very_first_time) { memset((char *)VS_buffer_for_message, '\0', (MAX_PRINT_MSG_LEN+MAX_FILENAME*MAXPROC)*sizeof(char)); VS_arg.val=0; for (i=0;i<=VS_nproc;i++){ if (semctl(VS_semid,i,SETVAL,VS_arg) == -1) { fprintf(stderr, "Error %d in semctl: %s\n",errno,sys_errlist[errno]); exit(errno); }; }; if ((pid = fork()) == -1) { fprintf(stderr, "Error %d in fork: %s\n",errno,sys_errlist[errno]); exit(errno); }; if (pid != 0) { *VS_array_pid=pid; signal(SIGINT, VS_wrapup); signal(SIGALRM, VS_timeout); VS_scheduler(); }; }; } void VS_clean_system() { int i; char *argv[2]; char VS_executable_file_name[]="./a.out"; argv[0]=VS_executable_file_name; argv[1]=NULL; for(i=0;i<*VS_nbr_of_semid_used;i++) semremove(*(VS_array_semid+i)); *VS_nbr_of_semid_used=0; for(i=0;i<*VS_nbr_of_shmid_used;i++) shmremove(*(VS_array_shmid+i)); *VS_nbr_of_shmid_used=0; for(i=0;i<*VS_nbr_of_msqid_used;i++) { VS_nbr_of_msg_in_msqid[i]=0; remove_queue(*(VS_array_msqid+i)); }; *VS_nbr_of_msqid_used=0; for(i=0;i<VS_nproc;i++) { if (*(VS_array_pid+i)) { if (sigusr2) kill(*(VS_array_pid+i), SIGUSR2); else kill(*(VS_array_pid+i), SIGKILL); } } if (wait(NULL)==-1) fprintf(stderr,"VeriSoft Error: error in wait \n"); if ((i = fork()) == -1) { fprintf(stderr, "Error %d in fork: %s\n",errno,sys_errlist[errno]); exit(errno); }; if (i == 0) { if (execvp(argv[0], argv) ==-1) { fprintf(stderr, "Error %d in execvp: %s\n",errno,sys_errlist[errno]); exit(errno); }; }; } int VS_print_next_sys_call(pid, trans) int pid, trans; { int *int_ptr; char *char_ptr; int ret=0; int_ptr=VS_shm+(4*pid); char_ptr=VS_array_filename+(MAX_FILENAME*(pid-1)); switch (*int_ptr) { case SEMAPHORE_WAIT: ret=fprintf(fo, "semwait(%d,%d,%d)", semid_to_id(*(int_ptr+1)), *(int_ptr+2), *(int_ptr+3)); break; case SEMAPHORE_SIGNAL: ret=fprintf(fo, "semsignal(%d,%d,%d)", semid_to_id(*(int_ptr+1)), *(int_ptr+2), *(int_ptr+3)); break; case ASSERT_VIOLATION: ret=fprintf(fo, "Assertion_Violation"); break; case ABORT: ret=fprintf(fo, "Abort"); break; case EXIT: ret=fprintf(fo, "Exit"); break; case DIVERGENCE: ret=fprintf(fo, "Divergence"); break; case TOSS: if (trans == -1) ret=fprintf(fo, "VS_toss(%d)", *(int_ptr+1)); else ret=fprintf(fo, "VS_toss(%d)=%d", *(int_ptr+1), (trans_stack+trans)->toss_choice); break; case PRINT: ret=fprintf(fo, "VS_print: "); break; case IS_QUEUE_FULL: ret=fprintf(fo, "is_queue_full(%d,%d)", msqid_to_id(*(int_ptr+1)), *(int_ptr+2)); break; case IS_QUEUE_EMPTY: ret=fprintf(fo, "is_queue_empty(%d,%d)", msqid_to_id(*(int_ptr+1)), *(int_ptr+2)); break; case SEND_TO_QUEUE: ret=fprintf(fo, "send_to_queue(%d,%d,", msqid_to_id(*(int_ptr+1)), *(int_ptr+2)); break; case RCV_FROM_QUEUE: if (*(int_ptr+3) == 1) ret=fprintf(fo, "rcv_from_queue_without_deadlock(%d,%d)", msqid_to_id(*(int_ptr+1)), *(int_ptr+2)); else ret=fprintf(fo, "rcv_from_queue(%d,%d)", msqid_to_id(*(int_ptr+1)), *(int_ptr+2)); break; case SYNCHRO_READ_FILE: ret=fprintf(fo, "synchro_read_file(%s)", char_ptr); break; case SYNCHRO_WRITE_FILE: ret=fprintf(fo, "synchro_write_file(%s)", char_ptr); break; case SYNCHRO_CREATE_LOCKED_FILE: ret=fprintf(fo, "synchro_create_locked_file(%s)", char_ptr); break; case SYNCHRO_REMOVE_FILE: ret=fprintf(fo, "synchro_remove_file(%s)", char_ptr); break; default: fprintf(stderr,"FATAL VeriSoft Error: unknown operation!\n"); VS_wrapup(); }; return(ret); } int VS_print_msg_of_previous_sys_call(type_of_system_call) int type_of_system_call; { int ret=0; switch (type_of_system_call) { case RCV_FROM_QUEUE: ret=fprintf(fo, "=%s", VS_buffer_for_message); break; case SEND_TO_QUEUE: ret=fprintf(fo, "%s)", VS_buffer_for_message); break; case PRINT: ret=fprintf(fo, "%s", VS_buffer_for_message); break; default: break; }; return(ret); } void VS_produce_error_path() { int i; char *VS_file_name[100]; sprintf((char *)VS_file_name,"error%d.path", VS_error_count); if (!(fo_VS=fopen((char *)VS_file_name,"w"))) { fprintf(stderr,"VeriSoft Error: cannot create %s\n", VS_file_name); VS_wrapup(); }; for(i=0;i!=dfs_stpt;i++) { fprintf(fo_VS, "%d %d\n", (trans_stack+((dfs_stack+i)->trans))->process_id, (trans_stack+((dfs_stack+i)->trans))->toss_choice); }; fclose(fo_VS); printf("error trace saved in %s\n", VS_file_name); VS_error_count++; if (VS_error_count>VS_stop_at_error) VS_wrapup(); } void VS_produce_seqflow_file(pid_error) int pid_error; { int i, pid; int type_of_system_call; signal(SIGALRM, SIG_IGN); scheduler_semwait(VS_semid,0,VS_nproc); if (!(fo=fopen("error.seq","w"))) { fprintf(stderr,"VeriSoft Error: cannot create error.seq"); VS_wrapup(); }; if (!(fo_VS=fopen("error.path","w"))) { fprintf(stderr,"VeriSoft Error: cannot create error.path"); VS_wrapup(); }; fprintf(fo, "&TITLE \"%s\";\n", VS_version); for(i=1;i<=VS_nproc;i++) fprintf(fo, "Process_%d ", i); fprintf(fo, ";\n"); for(i=0;i!=dfs_stpt;i++) { pid=(trans_stack+((dfs_stack+i)->trans))->process_id; fprintf(fo, "&ACTION "); VS_print_next_sys_call(pid, (dfs_stack+i)->trans); type_of_system_call=*(VS_shm+(4*pid)); execute_trans((dfs_stack+i)->trans); VS_print_msg_of_previous_sys_call(type_of_system_call); fprintf(fo, " Process_%d;\n", pid); fprintf(fo_VS, "%d %d\n", pid, (trans_stack+((dfs_stack+i)->trans))->toss_choice); }; if (pid_error) { fprintf(fo, "&ACTION "); VS_print_next_sys_call(pid_error, -1); fprintf(fo, " Process_%d;\n", pid_error); *(VS_shm+(4*pid_error))=DIVERGENCE; fprintf(fo_VS, "%d 0\n", pid_error); }; for(i=1;i<=VS_nproc;i++) { fprintf(fo, "&STATE STOPPED_in_"); VS_print_next_sys_call(i, -1); fprintf(fo, " Process_%d;\n", i); }; } void VS_pause() { semsignal(VS_semid,0,1);
#ifdef VS_DEBUG
printf("semwait on semaphore %d\n",VS_my_pid);
#endif
VS_pause_semwait(VS_semid,VS_my_pid,1); } void VS_safe_string_copy_into_VS_buffer(message) char *message; { int length_of_string_to_be_copied; length_of_string_to_be_copied=(int)strcspn(message,"\n"); if (length_of_string_to_be_copied<(MAX_PRINT_MSG_LEN-1)) { strncpy(VS_buffer_for_message,message,length_of_string_to_be_copied); VS_buffer_for_message[length_of_string_to_be_copied]=0; } else strncpy(VS_buffer_for_message,message,MAX_PRINT_MSG_LEN-1); } int VS_fork() { int VS_pid; if (!VS_init_done) VS_init(); if (!VS_first_fork_done) VS_first_fork_done=1; VS_count_proc++; if (VS_count_proc > VS_nproc) { fprintf(stderr, "VeriSoft Error: more than nproc processes!\n"); exit(0); }; VS_pid = fork(); if (VS_pid == 0) VS_my_pid=VS_count_proc; else *(VS_array_pid+VS_count_proc-1)=VS_pid; return (VS_pid); } int VS_semget(key, nsems, semflg) key_t key; int nsems, semflg; { if (!VS_init_done) VS_init(); if (VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use semget after fork!\n"); exit(0); }; *(VS_array_semid+*VS_nbr_of_semid_used)=semget(key, nsems, semflg); (*VS_nbr_of_semid_used)++; if (*VS_nbr_of_semid_used == MAXSEMID) { fprintf(stderr, "VeriSoft Error: more than MAXSEMID semids created!/n"); exit(0); }; return(*(VS_array_semid+(*VS_nbr_of_semid_used)-1)); } int VS_shmget(key, size, shmflg) key_t key; int size, shmflg; { if (!VS_init_done) VS_init(); if (VS_first_fork_done) { printf("VeriSoft Error: attempt to use shmget after fork!\n"); exit(0); }; *(VS_array_shmid+*VS_nbr_of_shmid_used)=shmget(key, size, shmflg); (*VS_nbr_of_shmid_used)++; if (*VS_nbr_of_shmid_used == MAXSHMID) { fprintf(stderr, "VeriSoft Error: more than MAXSHMID shmids created!/n"); exit(0); }; return(*(VS_array_shmid+(*VS_nbr_of_shmid_used)-1)); } int VS_semctl(semid, semnum, cmd, arg) int semid, semnum, cmd; Semun arg; { if (VS_first_fork_done) { printf("VeriSoft Warning: attempt to use semctl after fork!\n"); VS_exit(0); }; return(semctl(semid, semnum, cmd, arg)); } int VS_semop(semid, sops, nsops) int semid; struct sembuf *sops; int nsops; { if (VS_first_fork_done) { printf("VeriSoft Warning: attempt to use semop after fork!\n"); VS_exit(0); }; return(semop(semid, sops, nsops)); } int VS_semcreate(i) int i; { int semid; if ((semid = VS_semget(IPC_PRIVATE,i,PERMS)) == -1) { fprintf(stderr,"Error %d in semget: %s\n",errno,sys_errlist[errno]); exit(errno); }; return(semid); } void VS_semremove(semid) int semid; { if (VS_first_fork_done) { printf("VeriSoft Warning: attempt to use semremove after fork!\n"); VS_exit(0); }; return(semremove(semid)); } int VS_shmcreate(size) int size; { int shmid; if ((shmid = VS_shmget(IPC_PRIVATE,size,0600)) == -1) { fprintf(stderr,"Error %d in shmget: %s\n",errno,sys_errlist[errno]); exit(errno); } return(shmid); } void VS_shmremove(semid) int semid; { if (VS_first_fork_done) { printf("VeriSoft Warning: attempt to use shmremove after fork!\n"); VS_exit(0); }; return(shmremove(semid)); } void VS_sleep(seconds) unsigned seconds; { } void VS_dont_printf(format) char *format; { } void VS_exit(val) int val; { int *int_ptr; if (!VS_init_done) { fprintf(stderr,"VeriSoft Warning: program exits immediately!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=EXIT; VS_pause(); } void VS_semwait(semid,n,i) int semid, n, i; { int *int_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use semwait before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=SEMAPHORE_WAIT; *(int_ptr+1)=semid; *(int_ptr+2)=n; *(int_ptr+3)=i; VS_pause(); semwait(semid, n, i); } void VS_semsignal(semid,n,i) int semid, n, i; { int *int_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use semsignal before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=SEMAPHORE_SIGNAL; *(int_ptr+1)=semid; *(int_ptr+2)=n; *(int_ptr+3)=i; VS_pause(); semsignal(semid, n, i); } void VS_assert_viol() { int *int_ptr; if (!VS_init_done) { fprintf(stderr,"VeriSoft Warning: immediate assertion violation!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=ASSERT_VIOLATION; VS_pause(); } void VS_abort_viol() { int *int_ptr; if (!VS_init_done) { fprintf(stderr,"VeriSoft Warning: immediate abort!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=ABORT; VS_pause(); } int VS_toss(val) int val; { int *int_ptr; if (!VS_init_done) VS_init(); if ((!VS_first_fork_done) && (VS_nproc>1)) { fprintf(stderr,"VeriSoft Error: attempt to use VS_toss before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=TOSS; *(int_ptr+1)=val; VS_pause(); return(*(VS_shm+1)); } void VS_print(message) char *message; { int *int_ptr; if (!VS_init_done) VS_init(); if ((!VS_first_fork_done) && (VS_nproc>1)) { fprintf(stderr,"VeriSoft Error: attempt to use VS_print before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=PRINT; VS_pause(); VS_safe_string_copy_into_VS_buffer(message); } int VS_get_bounded_queue(bound) int bound; { if (!VS_init_done) VS_init(); if (VS_first_fork_done) { printf("VeriSoft Error: attempt to use get_bounded_queue after fork!\n"); exit(0); }; *(VS_array_msqid+*VS_nbr_of_msqid_used)=get_bounded_queue(bound); (*VS_nbr_of_msqid_used)++; if (*VS_nbr_of_msqid_used == MAXMSQID) { fprintf(stderr, "VeriSoft Error: more than MAXMSQID msqids created!\n"); exit(0); }; return(*(VS_array_msqid+(*VS_nbr_of_msqid_used)-1)); } void VS_remove_queue(msqid) int msqid; { if (VS_first_fork_done) { printf("VeriSoft Warning: attempt to use remove_queue after fork!\n"); VS_exit(0); }; remove_queue(msqid); } int VS_is_queue_full(msqid,bound) int msqid,bound; { int *int_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use is_queue_full before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=IS_QUEUE_FULL; *(int_ptr+1)=msqid; *(int_ptr+2)=bound; VS_pause(); return(is_queue_full(msqid,bound)); } int VS_is_queue_empty(msqid,bound) int msqid,bound; { int *int_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use is_queue_empty before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=IS_QUEUE_EMPTY; *(int_ptr+1)=msqid; *(int_ptr+2)=bound; VS_pause(); return(is_queue_empty(msqid,bound)); } void VS_send_to_queue(msqid,bound,message) int msqid,bound; char *message; { int *int_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use send_to_queue before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=SEND_TO_QUEUE; *(int_ptr+1)=msqid; *(int_ptr+2)=bound; VS_pause(); VS_safe_string_copy_into_VS_buffer(message); send_to_queue(msqid,bound,message); } char *VS_rcv_from_queue(msqid,bound) int msqid,bound; { int *int_ptr; char *message; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use rcv_from_queue before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=RCV_FROM_QUEUE; *(int_ptr+1)=msqid; *(int_ptr+2)=bound; *(int_ptr+3)=0; VS_pause(); message=(char *)rcv_from_queue(msqid,bound); VS_safe_string_copy_into_VS_buffer(message); return(message); } char *VS_rcv_from_queue_without_deadlock(msqid,bound) int msqid,bound; { int *int_ptr; char *message; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use rcv_from_queue_without_deadlock before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); *int_ptr=RCV_FROM_QUEUE; *(int_ptr+1)=msqid; *(int_ptr+2)=bound; *(int_ptr+3)=1; VS_pause(); message=(char *)rcv_from_queue(msqid,bound); VS_safe_string_copy_into_VS_buffer(message); return(message); } void VS_synchro_read_file(filename) char *filename; { int *int_ptr; char *char_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use VS_synchro_read_file before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); char_ptr=VS_array_filename+(MAX_FILENAME*(VS_my_pid-1)); *int_ptr=SYNCHRO_READ_FILE; strncpy(char_ptr,filename,MAX_FILENAME-1); VS_pause(); } void VS_synchro_write_file(filename) char *filename; { int *int_ptr; char *char_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use VS_synchro_write_file before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); char_ptr=VS_array_filename+(MAX_FILENAME*(VS_my_pid-1)); *int_ptr=SYNCHRO_WRITE_FILE; strncpy(char_ptr,filename,MAX_FILENAME-1); VS_pause(); } void VS_synchro_create_locked_file(filename) char *filename; { int *int_ptr; char *char_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use VS_synchro_create_locked_file before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); char_ptr=VS_array_filename+(MAX_FILENAME*(VS_my_pid-1)); *int_ptr=SYNCHRO_CREATE_LOCKED_FILE; strncpy(char_ptr,filename,MAX_FILENAME-1); VS_pause(); } void VS_synchro_remove_file(filename) char *filename; { int *int_ptr; char *char_ptr; if (!VS_first_fork_done) { fprintf(stderr,"VeriSoft Error: attempt to use VS_synchro_remove_file before fork!\n"); exit(0); }; int_ptr=VS_shm+(4*VS_my_pid); char_ptr=VS_array_filename+(MAX_FILENAME*(VS_my_pid-1)); *int_ptr=SYNCHRO_REMOVE_FILE; strncpy(char_ptr,filename,MAX_FILENAME-1); VS_pause(); } char *VS_emalloc(n) unsigned n; { char *tmp; tmp = (char *) malloc(n); if (!tmp) { printf("VeriSoft: out of memory\n"); VS_wrapup(); } memset(tmp, 0, n); return tmp; } char *VS_erealloc(p,n,old_n) char *p; unsigned n, old_n; { char *tmp; alarm(1000); tmp = (char *) realloc(p,n); if (!tmp) { printf("VeriSoft: out of memory\n"); VS_wrapup(); } memset(tmp+old_n, 0, n-old_n); return tmp; } int msqid_to_id(msqid) int msqid; { int i; for(i=0;i<*VS_nbr_of_msqid_used;i++) { if (*(VS_array_msqid+i) == msqid) return i; }; fprintf(stderr, "VeriSoft Error: unknown msqid!\n"); VS_produce_error_path(); VS_wrapup(); return; } int semid_to_id(semid) int semid; { int i; for(i=0;i<*VS_nbr_of_semid_used;i++) { if (*(VS_array_semid+i) == semid) return i; }; fprintf(stderr, "VeriSoft Error: unknown semid!\n"); VS_produce_error_path(); VS_wrapup(); return; } void scheduler_semwait(semid,n,i) int semid,n,i; { struct sembuf *sops; sops=(struct sembuf *)malloc(sizeof(struct sembuf)); sops[0].sem_num = n; sops[0].sem_op = -i; sops[0].sem_flg = 0; if (semop(semid,sops,1) == -1) { if (errno == 4) { VS_wrapup(); } else { fprintf(stderr,"pid %d, error %d in semop (scheduler_semwait), semid %d: %s\n", getpid(),errno,semid,sys_errlist[errno]); VS_wrapup(); }; }; free((char *)sops); } void VS_pause_semwait(semid,n,i) int semid,n,i; { struct sembuf *sops; sops=(struct sembuf *)malloc(sizeof(struct sembuf)); sops[0].sem_num = n; sops[0].sem_op = -i; sops[0].sem_flg = 0;
#ifdef SIMUL
if (semop(semid,sops,1) == -1) { if (errno != 4) { fprintf(stderr,"pid %d, error %d in semop (VS_pause_semwait), semid %d: %s\n", getpid(),errno,semid,sys_errlist[errno]); exit(errno); }; if (semop(semid,sops,1) == -1) { fprintf(stderr,"pid %d, error %d in semop (VS_pause_semwait), semid %d: %s\n", getpid(),errno,semid,sys_errlist[errno]); exit(errno); }; };
#else
if (semop(semid,sops,1) == -1) { fprintf(stderr,"pid %d, error %d in semop (VS_pause_semwait), semid %d: %s\n", getpid(),errno,semid,sys_errlist[errno]); exit(errno); };
#endif
free((char *)sops); } char *print_op_type(type) int type; { switch (type) { case SEMAPHORE_WAIT: return("semwait"); case SEMAPHORE_SIGNAL: return("semsignal"); case IS_QUEUE_FULL: return("is_queue_full"); case IS_QUEUE_EMPTY: return("is_queue_empty"); case SEND_TO_QUEUE: return("send_to_queue"); case RCV_FROM_QUEUE: return("rcv_from_queue"); case SYNCHRO_READ_FILE: return("synchro_read_file"); case SYNCHRO_WRITE_FILE: return("synchro_write_file"); case SYNCHRO_CREATE_LOCKED_FILE: return("synchro_create_locked_file"); case SYNCHRO_REMOVE_FILE: return("synchro_remove_file"); case ASSERT_VIOLATION: return("assertion_violation"); case EXIT: return("exit"); case DIVERGENCE: return("divergence"); case TOSS: return("VS_toss"); case ABORT: return("VS_abort"); case PRINT: return("VS_print"); default: return("VeriSoft Error: unknown type!"); } } void execute_trans(trans) int trans; { int *int_ptr; *(VS_shm+1)=(trans_stack+trans)->toss_choice; int_ptr=VS_shm+(4*((trans_stack+trans)->process_id)); if (*int_ptr==SEND_TO_QUEUE) VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))]++; else { if (*int_ptr==RCV_FROM_QUEUE) VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))]--; };
#ifndef SIMUL
if ((trans_stack+trans)->type == 0) (trans_stack+trans)->type=(*int_ptr)+1; else { if ((trans_stack+trans)->type != ((*int_ptr)+1)) { int i; for (i=0;i<dfs_stpt;i++) { if ((dfs_stack+i)->trans == trans) dfs_stpt=i+1; } printf("VeriSoft Error: the last transition executed is not deterministic!\n"); printf("\trecorded type of last transition is <%s>;\n\tactual type of last transition is <%s>\n",print_op_type(((trans_stack+trans)->type)-1), print_op_type(*int_ptr)); printf("this last transition is the last transition in the scenario saved below...\n"); VS_produce_error_path(); VS_wrapup(); } }
#endif
#ifdef VS_DEBUG
printf("execution of trans %d\n", trans);
#endif
semsignal(VS_semid,(trans_stack+trans)->process_id,1); scheduler_semwait(VS_semid,0,1); } void Srand(s) unsigned int s; { Seed = s; } long VS_Rand() { Seed = 16807*(Seed%127773) - 2836*(Seed/127773); if (Seed <= 0) Seed += 2147483647; return Seed; } void VS_process_system_file() { FILE *f_ptr; char input[MAXLINE]; int i, j, k, parameter_index; int parameter[20]; char *parameters_name[]={ "#", "nproc", "max_depth", "depth_incr", "livelock_limit", "semwait", "semsignal", "is_queue_full", "is_queue_empty", "send_to_queue", "rcv_from_queue", "ignore_deadlock", "init_path", "divergence_limit", "stop_at_error", "save_state_space", "max_sss", "stop_at_state", "random_seed", "sigusr2", 0 }; if (!(f_ptr=fopen("./system_file.VS","r"))) { fprintf(stderr, "VeriSoft Error: cannot read ./system_file.VS\n"); shmremove(VS_shmid); exit(0); }; Operation_proc_stack_size=OPERATION_STACK_SIZE; Operation_obj_stack_size=OPERATION_STACK_SIZE; Operation_proc_stack=(struct Operation_proc_elem *)VS_emalloc(Operation_proc_stack_size*sizeof(struct Operation_proc_elem)); Operation_obj_stack=(struct Operation_obj_elem *)VS_emalloc(Operation_obj_stack_size*sizeof(struct Operation_obj_elem)); Operation_proc_stpt=Operation_obj_stpt=0; for (i=0; i<NUMBER_OF_TYPES_OF_COM_OBJ; i++) VS_operations[i]=-1; parameter[1]=0; parameter[2]=100; parameter[3]=5; parameter[4]=15; parameter[11]=0; parameter[13]=10; parameter[14]=1; parameter[15]=0; parameter[16]=10000000; parameter[17]=0; parameter[18]=1; parameter[19]=0; while (fscanf(f_ptr, "%s", input) != EOF) { parameter_index=-1; for (i=0; parameters_name[i]; i++) { if (strcmp(parameters_name[i], input) == 0) { parameter_index=i; break; }; }; if (parameter_index == -1) { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown parameter %s\n", input); shmremove(VS_shmid); exit(0); }; if (parameter_index == 0) { fgets(input, MAXLINE, f_ptr); continue; }; if (parameter_index == 5) { if (fscanf(f_ptr, "%d %d %d", &i, &j, &k) == 3) { create_list_of_proc(SEMAPHORE_WAIT, i, j, k); fgets(input, MAXLINE, f_ptr); continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (parameter_index == 6) { if (fscanf(f_ptr, "%d %d %d", &i, &j, &k) == 3) { create_list_of_proc(SEMAPHORE_SIGNAL, i, j, k); fgets(input, MAXLINE, f_ptr); continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (parameter_index == 7) { if (fscanf(f_ptr, "%d %d", &i, &j) == 2) { create_list_of_proc(IS_QUEUE_FULL, i, 0, j); fgets(input, MAXLINE, f_ptr); continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (parameter_index == 8) { if (fscanf(f_ptr, "%d %d", &i, &j) == 2) { create_list_of_proc(IS_QUEUE_EMPTY, i, 0, j); fgets(input, MAXLINE, f_ptr); continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (parameter_index == 9) { if (fscanf(f_ptr, "%d %d", &i, &j) == 2) { create_list_of_proc(SEND_TO_QUEUE, i, 0, j); fgets(input, MAXLINE, f_ptr); continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (parameter_index == 10) { if (fscanf(f_ptr, "%d %d", &i, &j) == 2) { create_list_of_proc(RCV_FROM_QUEUE, i, 0, j); fgets(input, MAXLINE, f_ptr); continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (parameter_index == 12) { VS_init_path=(char *)VS_emalloc(MAXLINE*sizeof(char)); if (fscanf(f_ptr, "%s", VS_init_path) == 1) { fgets(input, MAXLINE, f_ptr); continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (fscanf(f_ptr, "%d", &i) == 1) { parameter[parameter_index]=i; fgets(input, MAXLINE, f_ptr); if (parameter_index == 1) VS_nproc=parameter[1]; continue; } else { fprintf(stderr, "VeriSoft Error: syntax error in ./system_file.VS -- unknown argument for parameter %s\n", input); shmremove(VS_shmid); exit(0); }; }; if (parameter[1] == 0) { fprintf(stderr, "VeriSoft Error: unknown value for nproc\n"); shmremove(VS_shmid); exit(0); } else { *VS_shm=VS_nproc; }; if (VS_nproc > MAXPROC) { fprintf(stderr, "VeriSoft Error: more than MAXPROC processes!\n"); shmremove(VS_shmid); exit(0); }; VS_max_depth=parameter[2]; VS_depth_incr=parameter[3]; VS_livelock_limit=parameter[4]; VS_ignore_deadlock=parameter[11]; VS_divergence_limit=parameter[13]; VS_stop_at_error=parameter[14]; VS_save_state_space=parameter[15];
#ifdef RANDOM_MEMORY_LESS_SEARCH
VS_save_state_space=1;
#endif
VS_max_sss=parameter[16]*1000000; VS_stop_at_state=parameter[17]; Srand(parameter[18]); sigusr2=parameter[19]; } void create_list_of_proc(op, obj_id, index, proc) int op, obj_id, index, proc; { int i, j, found; if ((proc < 0) || (proc > VS_nproc)) { fprintf(stderr, "VeriSoft Error in ./system_file.VS: process_%d does not exist\n", proc); fprintf(stderr, "(%d is not between 0 and nproc=%d)\n", proc, VS_nproc); shmremove(VS_shmid); exit(0); }; i=VS_operations[op]; found=-1; while (i != -1) { if (((Operation_obj_stack+i)->obj == obj_id) && ((Operation_obj_stack+i)->index == index)) { found=(Operation_obj_stack+i)->first_Operation_proc_elem; break; } else { i=(Operation_obj_stack+i)->next; }; }; (Operation_proc_stack+Operation_proc_stpt)->proc=proc; (Operation_proc_stack+Operation_proc_stpt)->next=found; if (i == -1) { (Operation_obj_stack+Operation_obj_stpt)->obj=obj_id; (Operation_obj_stack+Operation_obj_stpt)->index=index; (Operation_obj_stack+Operation_obj_stpt)->first_Operation_proc_elem=Operation_proc_stpt; (Operation_obj_stack+Operation_obj_stpt)->next=VS_operations[op]; VS_operations[op]=Operation_obj_stpt; Operation_obj_stpt++; if (Operation_obj_stpt==Operation_obj_stack_size) { j=Operation_obj_stack_size+OPERATION_STACK_SIZE; Operation_obj_stack=(struct Operation_obj_elem *)VS_erealloc((char *)Operation_obj_stack, j*sizeof(struct Operation_obj_elem), Operation_obj_stack_size*sizeof(struct Operation_obj_elem)); Operation_obj_stack_size=j; }; } else { (Operation_obj_stack+i)->first_Operation_proc_elem=Operation_proc_stpt; }; Operation_proc_stpt++; if (Operation_proc_stpt==Operation_proc_stack_size) { j=Operation_proc_stack_size+OPERATION_STACK_SIZE; Operation_proc_stack=(struct Operation_proc_elem *)VS_erealloc((char *)Operation_proc_stack, j*sizeof(struct Operation_proc_elem), Operation_proc_stack_size*sizeof(struct Operation_proc_elem)); Operation_proc_stack_size=j; }; } int list_of_proc(op, obj_id, index) int op, obj_id, index; { int i; i=VS_operations[op]; while (i != -1) { if (((Operation_obj_stack+i)->obj == obj_id) && ((Operation_obj_stack+i)->index == index)) { break; } else { i=(Operation_obj_stack+i)->next; }; }; if (i == -1) { return(-1); } else { return((Operation_obj_stack+i)->first_Operation_proc_elem); }; } void check(op, obj_id, index, proc) int op, obj_id, index, proc; { int i; if ((op == SEMAPHORE_WAIT) || (op == SEMAPHORE_SIGNAL)) { obj_id=semid_to_id(obj_id); } else if ((op >= IS_QUEUE_FULL) && (op <= RCV_FROM_QUEUE)) { obj_id=msqid_to_id(obj_id); index=0; }; i=list_of_proc(op, obj_id, index); if (i == -1) return; while (i != -1) { if ((Operation_proc_stack+i)->proc == proc) return; i=(Operation_proc_stack+i)->next; }; printf("VeriSoft Error: process_%d attempts to perform ", proc); fo=stdout; VS_print_next_sys_call(proc, -1); printf("\nat depth %d -- contradiction with ./system_file.VS\n",dfs_stpt); VS_produce_error_path(); VS_wrapup(); } void update_sleep_sets(trans, s, s_prime) int trans, s, s_prime; { char sleep_set[MAXPROC_CHAR]; int pid_of_trans, sem_new_value, i; int *int_ptr, *int_ptr_bis; char *char_ptr, *char_ptr_bis;
#if (defined EXHAUSTIVE) || (defined NO_SLEEP)
memcpy((char *)(state_stack+s_prime)->sleep_proc, (char *)(state_stack+s)->sleep_proc, MAXPROC_CHAR*sizeof(char));
#else
memcpy((char *)sleep_set, (char *)(state_stack+s)->sleep_proc, MAXPROC_CHAR*sizeof(char)); pid_of_trans=(trans_stack+trans)->process_id; bunset(sleep_set, pid_of_trans); int_ptr=VS_shm+(4*pid_of_trans); switch (*int_ptr) { case SEMAPHORE_WAIT: sem_new_value=semgetval(*(int_ptr+1), *(int_ptr+2))-(*(int_ptr+3)); for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == SEMAPHORE_WAIT) && (*(int_ptr+1) == *(int_ptr_bis+1)) && (*(int_ptr+2) == *(int_ptr_bis+2)) && (sem_new_value < *(int_ptr_bis+3))) bunset(sleep_set,i); }; break; case SEMAPHORE_SIGNAL: break; case EXIT: break; case TOSS: break; case PRINT: break; case IS_QUEUE_FULL: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == *(int_ptr+2)) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == RCV_FROM_QUEUE) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; } else if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == (*(int_ptr+2)-1)) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == SEND_TO_QUEUE) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; break; case IS_QUEUE_EMPTY: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == 0) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == SEND_TO_QUEUE) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; } else if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == 1) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == RCV_FROM_QUEUE) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; break; case SEND_TO_QUEUE: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] < *(int_ptr+2)) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == SEND_TO_QUEUE) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == 0) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == IS_QUEUE_EMPTY) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == (*(int_ptr+2)-1)) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == IS_QUEUE_FULL) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; break; case RCV_FROM_QUEUE: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] > 0) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == RCV_FROM_QUEUE) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == 1) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == IS_QUEUE_EMPTY) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == *(int_ptr+2)) { for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); if ((*int_ptr_bis == IS_QUEUE_FULL) && (*(int_ptr+1) == *(int_ptr_bis+1))) bunset(sleep_set,i); }; }; break; case SYNCHRO_READ_FILE: char_ptr=VS_array_filename+(MAX_FILENAME*(pid_of_trans-1)); for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); char_ptr_bis=VS_array_filename+(MAX_FILENAME*(i-1)); if ((*int_ptr_bis == SYNCHRO_WRITE_FILE) && (strcmp(char_ptr,char_ptr_bis)==0)) bunset(sleep_set,i); }; break; case SYNCHRO_WRITE_FILE: char_ptr=VS_array_filename+(MAX_FILENAME*(pid_of_trans-1)); for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); char_ptr_bis=VS_array_filename+(MAX_FILENAME*(i-1)); if (((*int_ptr_bis == SYNCHRO_READ_FILE) || (*int_ptr_bis == SYNCHRO_WRITE_FILE)) && (strcmp(char_ptr,char_ptr_bis)==0)) bunset(sleep_set,i); }; break; case SYNCHRO_CREATE_LOCKED_FILE: char_ptr=VS_array_filename+(MAX_FILENAME*(pid_of_trans-1)); for(i=1; i<=VS_nproc; i++) { int_ptr_bis=VS_shm+(4*i); char_ptr_bis=VS_array_filename+(MAX_FILENAME*(i-1)); if ((*int_ptr_bis == SYNCHRO_CREATE_LOCKED_FILE) && (strcmp(char_ptr,char_ptr_bis)==0)) bunset(sleep_set,i); }; break; case SYNCHRO_REMOVE_FILE: break; default: fprintf(stderr, "VeriSoft Error: unknown operation!\n"); VS_wrapup(); break; }; memcpy((char *)(state_stack+s_prime)->sleep_proc, (char *)sleep_set, MAXPROC_CHAR*sizeof(char)); bset((state_stack+s)->sleep_proc, pid_of_trans);
#endif
} void process_init_path() { int in_pid, in_toss, j; char input[MAXLINE]; while (fscanf(fo_init_path, "%d", &in_pid) == 1) { if ((in_pid < 1) || (in_pid > VS_nproc)) { fprintf(stderr, "VeriSoft Error: syntax error in init_path file = %s\n", VS_init_path); VS_wrapup(); }; if (fscanf(fo_init_path, "%d", &in_toss) != 1) { fprintf(stderr, "VeriSoft Error: syntax error in init_path file = %s\n", VS_init_path); VS_wrapup(); }; fgets(input, MAXLINE, fo_init_path); (trans_stack+number_of_trans)->label=number_of_trans; (trans_stack+number_of_trans)->process_id=in_pid; (trans_stack+number_of_trans)->toss_choice=in_toss; (trans_stack+number_of_trans)->previous_trans=(dfs_stpt) ? (dfs_stack+dfs_stpt-1)->trans : -1; (trans_stack+number_of_trans)->successor_state=number_of_states+1; (state_stack+number_of_states)->number_of_succ=1; (state_stack+number_of_states)->first_next_trans=number_of_trans; memset((char *)(state_stack+number_of_states)->sleep_proc, 0, MAXPROC_CHAR*sizeof(char)); (dfs_stack+dfs_stpt)->trans=number_of_trans; (dfs_stack+dfs_stpt)->remaining=0; VS_length_of_init_path++; number_of_states++; if (number_of_states==state_stack_size) { j=state_stack_size+BASIC_SIZE; state_stack=(struct State *)VS_erealloc((char*)state_stack, j*sizeof(struct State), state_stack_size*sizeof(struct State)); state_stack_size=j; }; dfs_stpt++; if (dfs_stpt==dfs_stack_size) { j=dfs_stack_size+BASIC_SIZE; dfs_stack=(struct El_dfs_stack *)VS_erealloc((char *)dfs_stack, j*sizeof(struct El_dfs_stack), dfs_stack_size*sizeof(struct El_dfs_stack)); dfs_stack_size=j; }; number_of_trans++; if (number_of_trans==trans_stack_size) { j=trans_stack_size+BASIC_SIZE; trans_stack=(struct Trans *)VS_erealloc((char *)trans_stack, j*sizeof(struct Trans), trans_stack_size*sizeof(struct Trans)); trans_stack_size=j; }; }; return; }
#ifndef SIMUL
void VS_close_sss(add_to_size_of_sss) int add_to_size_of_sss; { fclose(fo_sss); VS_save_state_space=0; printf("\nclosing file sss.VS"); if (add_to_size_of_sss < 0) printf(": write error in file sss.VS !\n\n"); else printf(" since limit of %d Mb is reached\n\n",(VS_max_sss/1000000)); } void VS_print_trans_in_sss_pre(trans) int trans; { int pid; int add_to_size_of_sss; add_to_size_of_sss=fprintf(fo_sss,"%d\t%d\t%d\t%d\t%d\t", ((trans_stack+trans)->previous_trans == -1) ? 0 : (trans_stack+((trans_stack+trans)->previous_trans))->successor_state, ((trans_stack+trans)->successor_state == 0) ? number_of_states : (trans_stack+trans)->successor_state, (trans_stack+trans)->label, (trans_stack+trans)->process_id, (trans_stack+trans)->toss_choice); if (add_to_size_of_sss < 0) VS_close_sss(add_to_size_of_sss); else size_of_sss+=add_to_size_of_sss; fo=fo_sss; pid=(trans_stack+trans)->process_id; add_to_size_of_sss=VS_print_next_sys_call(pid,trans); if (add_to_size_of_sss < 0) VS_close_sss(add_to_size_of_sss); else size_of_sss+=add_to_size_of_sss; type_of_sys_call=*(VS_shm+(4*pid)); } void VS_print_trans_in_sss_post() { int add_to_size_of_sss; add_to_size_of_sss=VS_print_msg_of_previous_sys_call(type_of_sys_call); if (add_to_size_of_sss < 0) VS_close_sss(add_to_size_of_sss); else size_of_sss+=add_to_size_of_sss; fprintf(fo_sss,"\n"); size_of_sss++; if (size_of_sss >= VS_max_sss) VS_close_sss(0); }
#endif
void VS_scheduler() { int i, j, number_of_succ_trans, wait_on_rcv_from_queue_without_deadlock; int pid, temp_trans; int *int_ptr; int k, branching, m; int report_state_limit; int max_depth; int min_depth; int *leaf_stack; int leaf_stack_size; int leaf_stpt; int *previous_leaf_stack; int previous_leaf_stpt; int *temp_stack; int temp_stack_size; int temp_stpt; int *last_enabled_stack; int last_enabled_stack_size; int *previous_last_enabled_stack; int *last_enabled; char *enabled_proc; char *selected_proc; char *seed_proc; char *PS; int *PS_stack; int PS_stpt; int min_number_of_en_in_PS; int number_of_en_in_PS; int P_i; int proc_elem_ptr; char sleep_set[MAXPROC_CHAR]; struct stat *stat_buf; int add_to_size_of_sss; trans_stack_size=BASIC_SIZE; state_stack_size=BASIC_SIZE; dfs_stack_size=BASIC_SIZE; leaf_stack_size=BASIC_SIZE; temp_stack_size=BASIC_SIZE; last_enabled_stack_size=BASIC_SIZE; trans_stack=(struct Trans *)VS_emalloc(trans_stack_size*sizeof(struct Trans)); state_stack=(struct State *)VS_emalloc(state_stack_size*sizeof(struct State)); dfs_stack=(struct El_dfs_stack *)VS_emalloc(dfs_stack_size*sizeof(struct El_dfs_stack)); leaf_stack=(int *)VS_emalloc(leaf_stack_size*sizeof(int)); previous_leaf_stack=(int *)VS_emalloc(leaf_stack_size*sizeof(int)); temp_stack=(int *)VS_emalloc(temp_stack_size*sizeof(int)); last_enabled_stack=(int *)VS_emalloc(last_enabled_stack_size*sizeof(int)); previous_last_enabled_stack=(int *)VS_emalloc(last_enabled_stack_size*sizeof(int)); last_enabled=(int *)VS_emalloc(VS_nproc*sizeof(int)); enabled_proc=(char *)VS_emalloc(MAXPROC_CHAR*sizeof(char)); selected_proc=(char *)VS_emalloc(MAXPROC_CHAR*sizeof(char)); seed_proc=(char *)VS_emalloc(MAXPROC_CHAR*sizeof(char)); PS=(char *)VS_emalloc(MAXPROC_CHAR*sizeof(char)); PS_stack=(int *)VS_emalloc(MAXPROC*sizeof(int)); number_of_states=number_of_trans=0; memset((char *)(state_stack+number_of_states)->sleep_proc, 0, MAXPROC_CHAR*sizeof(char)); memset((char *)sleep_set, 0, MAXPROC_CHAR*sizeof(char)); stat_buf=(struct stat *)malloc(sizeof(struct stat));
#ifdef EDV
if (!(fo_sss=fopen("sss-trans.VS","w"))) { fprintf(stderr,"VeriSoft Error: cannot create sss-trans.VS !\n"); VS_wrapup(); }; fprintf(fo_sss,"org.\tdest.\tlabel\tpid\ttoss\ttext\n"); fprintf(fo_sss,"i\ti\ti\ti\ti\ts\n");
#endif
#ifdef SS
if (!(fo_ss=fopen("ss.VS","w"))) { fprintf(stderr,"VeriSoft Error: cannot create ss.VS\n"); VS_wrapup(); };
#endif
dfs_stpt=leaf_stpt=previous_leaf_stpt=0;
#ifndef SIMUL
if (VS_init_path != 0) { if (!(fo_init_path=fopen(VS_init_path,"r"))) { fprintf(stderr,"VeriSoft Error: cannot read init_path = %s\n",VS_init_path); VS_wrapup(); }; process_init_path(); fclose(fo_init_path); };
#endif
report_state_limit=REPORT_STATE_UNIT; min_depth=VS_length_of_init_path; max_depth=VS_depth_incr+VS_length_of_init_path; if (max_depth > VS_max_depth) max_depth=VS_max_depth; if (max_depth == 0) { fprintf(stderr,"VeriSoft Error: VS_max_depth is 0 !!!\n"); VS_wrapup(); }; printf("%s:\n\tsearch for ", VS_version); if (!VS_ignore_deadlock) printf("deadlocks, "); printf("livelocks, divergences, and assertion violations\n\n");
#ifndef SIMUL
if (VS_save_state_space) { printf("state space saved in file sss.VS\n\n"); if (!(fo_sss=fopen("sss.VS","w"))) { fprintf(stderr,"VeriSoft Error: cannot create sss.VS !\n"); VS_wrapup(); }; };
#endif
#ifdef SIMUL
printf("VS_divergence_limit is %d\n\n",VS_divergence_limit);
#endif
Backtrack:
#ifdef VS_DEBUG
printf("Backtrack: semwait on semaphore %d\n",0);
#endif
#ifndef SIMUL
alarm(VS_divergence_limit);
#endif
scheduler_semwait(VS_semid,0,VS_nproc);
#ifdef SIMUL
for(i=0;i<VS_nproc;i++) printf("pid: %d\n", *(VS_array_pid+i));
#endif
if (dfs_stpt) {
#ifdef RANDOM_MEMORY_LESS_SEARCH
VS_save_state_space=0;
#endif
#ifndef SIMUL
if (VS_save_state_space && VS_init_path) { fprintf(fo_sss,"\n"); size_of_sss++; };
#endif
for(i=0;i<(dfs_stpt-1);i++) {
#ifndef SIMUL
if (VS_save_state_space && VS_init_path) VS_print_trans_in_sss_pre((dfs_stack+i)->trans); alarm(VS_divergence_limit);
#endif
execute_trans((dfs_stack+i)->trans);
#ifndef SIMUL
if (VS_save_state_space && VS_init_path) { VS_print_trans_in_sss_post(); fprintf(fo_sss,"\n"); size_of_sss++; };
#endif
};
#ifdef RANDOM_MEMORY_LESS_SEARCH
VS_save_state_space=1;
#endif
if (dfs_stpt == VS_length_of_init_path) {
#ifdef RANDOM_MEMORY_LESS_SEARCH
VS_save_state_space=0;
#endif
#ifndef SIMUL
if (VS_save_state_space && VS_init_path) VS_print_trans_in_sss_pre((dfs_stack+dfs_stpt-1)->trans); alarm(VS_divergence_limit);
#endif
execute_trans((dfs_stack+dfs_stpt-1)->trans);
#ifndef SIMUL
if (VS_save_state_space && VS_init_path) VS_print_trans_in_sss_post();
#endif
#ifdef RANDOM_MEMORY_LESS_SEARCH
VS_save_state_space=1;
#endif
printf("Search starting after init_path = %s\n", VS_init_path); VS_init_path=0; } else { update_sleep_sets((dfs_stack+dfs_stpt-1)->trans, ((dfs_stpt) > 1) ? (trans_stack+(dfs_stack+dfs_stpt-2)->trans)->successor_state : 0, number_of_states);
#ifndef SIMUL
if (VS_save_state_space) VS_print_trans_in_sss_pre((dfs_stack+dfs_stpt-1)->trans);
#endif
#ifdef EDV
temp_trans=(dfs_stack+dfs_stpt-1)->trans; fprintf(fo_sss,"%d\t%d\t%d\t%d\t%d\t", ((trans_stack+temp_trans)->previous_trans == -1) ? 0 : (trans_stack+((trans_stack+temp_trans)->previous_trans))->successor_state, number_of_states, (trans_stack+temp_trans)->label, (trans_stack+temp_trans)->process_id, (trans_stack+temp_trans)->toss_choice); fo=fo_sss; pid=(trans_stack+temp_trans)->process_id; VS_print_next_sys_call(pid,temp_trans); type_of_sys_call=*(VS_shm+(4*pid));
#endif
#ifdef SS
temp_trans=(dfs_stack+dfs_stpt-1)->trans; fprintf(fo_ss,"%d\t%d\t%d\t", ((trans_stack+temp_trans)->previous_trans == -1) ? 0 : (trans_stack+((trans_stack+temp_trans)->previous_trans))->successor_state, number_of_states, (trans_stack+temp_trans)->process_id); fo=fo_ss; pid=(trans_stack+temp_trans)->process_id; VS_print_next_sys_call(pid,temp_trans); type_of_sys_call=*(VS_shm+(4*pid));
#endif
#ifndef SIMUL
alarm(VS_divergence_limit);
#endif
execute_trans((dfs_stack+dfs_stpt-1)->trans); (trans_stack+((dfs_stack+dfs_stpt-1)->trans))->successor_state=number_of_states;
#ifndef SIMUL
if (VS_save_state_space) VS_print_trans_in_sss_post();
#endif
#ifdef EDV
VS_print_msg_of_previous_sys_call(type_of_sys_call); fprintf(fo_sss,"\n");
#endif
#ifdef SS
VS_print_msg_of_previous_sys_call(type_of_sys_call); fprintf(fo_ss,"\n");
#endif
}; }; Down: memset((char *)enabled_proc, 0, MAXPROC_CHAR*sizeof(char)); number_of_succ_trans=0; wait_on_rcv_from_queue_without_deadlock=0; for(i=1;i<=VS_nproc;i++) { int_ptr=VS_shm+(4*i); if (*int_ptr==ASSERT_VIOLATION) {
#ifdef SIMUL
printf("to VeriSoft simulator: assertion violation!\n"); number_of_succ_trans=0; goto reask;
#else
printf("assertion violation detected at depth %d !!!\n", dfs_stpt); if (VS_save_state_space) { fprintf(fo_sss,"1\n"); size_of_sss+=2; }; VS_produce_error_path(); number_of_succ_trans=0; goto Continue_search_after_error;
#endif
}; if (*int_ptr==ABORT) {
#ifdef SIMUL
printf("to VeriSoft simulator: abort!\n"); number_of_succ_trans=0; goto reask;
#else
if (VS_save_state_space) { fprintf(fo_sss,"3\n"); size_of_sss+=2; }; number_of_succ_trans=0; goto Continue_search_after_error;
#endif
}; if ((*int_ptr==RCV_FROM_QUEUE) && (*(int_ptr+3)==1)) wait_on_rcv_from_queue_without_deadlock=1; if ( (*int_ptr==SEMAPHORE_SIGNAL) || (*int_ptr==TOSS) || (*int_ptr==PRINT) || (*int_ptr==IS_QUEUE_FULL) || (*int_ptr==IS_QUEUE_EMPTY) || ((*int_ptr==SEMAPHORE_WAIT) && (semgetval(*(int_ptr+1), *(int_ptr+2)) >= *(int_ptr+3))) || ((*int_ptr==SEND_TO_QUEUE) && (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] < *(int_ptr+2))) || ((*int_ptr==RCV_FROM_QUEUE) && (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] > 0)) || (*int_ptr==SYNCHRO_READ_FILE) || (*int_ptr==SYNCHRO_WRITE_FILE) || ((*int_ptr==SYNCHRO_CREATE_LOCKED_FILE) && (stat((char *)VS_array_filename+(MAX_FILENAME*(i-1)),stat_buf) == -1)) || (*int_ptr==SYNCHRO_REMOVE_FILE) ) { bset(enabled_proc,i); number_of_succ_trans++; if (last_enabled[i-1]!=-1) last_enabled[i-1]=dfs_stpt; }; }; if (number_of_succ_trans == 0) { if (wait_on_rcv_from_queue_without_deadlock==1) {
#ifdef SIMUL
printf("to VeriSoft simulator: abort!\n"); goto reask;
#else
if (VS_save_state_space) { fprintf(fo_sss,"3\n"); size_of_sss+=2; }; goto Continue_search_after_error;
#endif
};
#ifdef SIMUL
printf("to VeriSoft simulator: deadlock!\n"); number_of_succ_trans=0; goto reask;
#else
if (VS_save_state_space) { fprintf(fo_sss,"2\n"); size_of_sss+=2; }; if (!VS_ignore_deadlock) { printf("\ndeadlock detected at depth %d !!!\n", dfs_stpt); for(i=1;i<=VS_nproc;i++) { int_ptr=VS_shm+(4*i); if (*int_ptr!=EXIT) break; if (i==VS_nproc) printf("(all processes terminate on exit)\n"); }; VS_produce_error_path(); }; goto Continue_search_after_error;
#endif
};
#ifndef SIMUL
if (VS_save_state_space) { fprintf(fo_sss,"\n"); size_of_sss++; };
#endif
#if (defined EXHAUSTIVE) || (defined NO_PERSISTENT)
selected_proc=enabled_proc; memcpy((char *)sleep_set, (char *)(state_stack+number_of_states)->sleep_proc ,MAXPROC_CHAR*sizeof(char));
#else
memcpy((char *)sleep_set, (char *)(state_stack+number_of_states)->sleep_proc ,MAXPROC_CHAR*sizeof(char)); memcpy((char *)selected_proc, (char *)enabled_proc, MAXPROC_CHAR*sizeof(char)); min_number_of_en_in_PS=MAXPROC+1; memset((char *)seed_proc, 0, MAXPROC_CHAR*sizeof(char)); for(i=1;i<=VS_nproc;i++) { if (!bis_set(enabled_proc,i)) continue; int_ptr=VS_shm+(4*i); if (*int_ptr < NUMBER_OF_TYPES_OF_COM_OBJ) { check(*int_ptr, *(int_ptr+1), *(int_ptr+2), i); }; memset((char *)PS, 0, MAXPROC_CHAR*sizeof(char)); bset(PS,i); number_of_en_in_PS=0; PS_stpt=0; PS_stack[PS_stpt++]=i; while (PS_stpt) { P_i=PS_stack[--PS_stpt]; if (P_i == 0) continue; int_ptr=VS_shm+(4*P_i); if (bis_set(enabled_proc, P_i) && !bis_set(sleep_set,P_i)) { number_of_en_in_PS += (*int_ptr==TOSS) ? *(int_ptr+1) : 1; }; if ((number_of_en_in_PS >= min_number_of_en_in_PS) || bis_set(seed_proc, P_i)) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; switch (*int_ptr) { case SEMAPHORE_WAIT: if (bis_set(enabled_proc, P_i)) { proc_elem_ptr=list_of_proc(SEMAPHORE_WAIT, semid_to_id(*(int_ptr+1)), *(int_ptr+2)); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; } else { proc_elem_ptr=list_of_proc(SEMAPHORE_SIGNAL, semid_to_id(*(int_ptr+1)), *(int_ptr+2)); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; break; case SEMAPHORE_SIGNAL: break; case EXIT: break; case TOSS: break; case PRINT: break; case IS_QUEUE_FULL: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] < *(int_ptr+2)) { proc_elem_ptr=list_of_proc(SEND_TO_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; } else { proc_elem_ptr=list_of_proc(RCV_FROM_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; break; case IS_QUEUE_EMPTY: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] > 0) { proc_elem_ptr=list_of_proc(RCV_FROM_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; } else { proc_elem_ptr=list_of_proc(SEND_TO_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; break; case SEND_TO_QUEUE: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] < *(int_ptr+2)) { proc_elem_ptr=list_of_proc(SEND_TO_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; proc_elem_ptr=list_of_proc(IS_QUEUE_EMPTY, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == (*(int_ptr+2)-1)) { proc_elem_ptr=list_of_proc(IS_QUEUE_FULL, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; } else { proc_elem_ptr=list_of_proc(RCV_FROM_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; break; case RCV_FROM_QUEUE: if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] > 0) { proc_elem_ptr=list_of_proc(RCV_FROM_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; proc_elem_ptr=list_of_proc(IS_QUEUE_FULL, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; if (VS_nbr_of_msg_in_msqid[msqid_to_id(*(int_ptr+1))] == 1) { proc_elem_ptr=list_of_proc(IS_QUEUE_EMPTY, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; } else { proc_elem_ptr=list_of_proc(SEND_TO_QUEUE, msqid_to_id(*(int_ptr+1)), 0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; break; case SYNCHRO_READ_FILE: proc_elem_ptr=list_of_proc(SYNCHRO_WRITE_FILE,0,0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; break; case SYNCHRO_WRITE_FILE: proc_elem_ptr=list_of_proc(SYNCHRO_READ_FILE,0,0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; proc_elem_ptr=list_of_proc(SYNCHRO_WRITE_FILE,0,0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; break; case SYNCHRO_CREATE_LOCKED_FILE: if (bis_set(enabled_proc, P_i)) { proc_elem_ptr=list_of_proc(SYNCHRO_CREATE_LOCKED_FILE,0,0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; } else { proc_elem_ptr=list_of_proc(SYNCHRO_REMOVE_FILE,0,0); if (proc_elem_ptr == -1) { number_of_en_in_PS=min_number_of_en_in_PS; break; }; while (proc_elem_ptr != -1) { if (!(bis_set(PS,(Operation_proc_stack+proc_elem_ptr)->proc))) { PS_stack[PS_stpt++]=(Operation_proc_stack+proc_elem_ptr)->proc; bset(PS,(Operation_proc_stack+proc_elem_ptr)->proc); }; proc_elem_ptr=(Operation_proc_stack+proc_elem_ptr)->next; }; }; break; case SYNCHRO_REMOVE_FILE: break; default: fprintf(stderr, "VeriSoft Error: unknown operation!\n"); VS_wrapup(); break; }; }; bset(seed_proc,i); if (number_of_en_in_PS < min_number_of_en_in_PS) { memcpy((char *)selected_proc, (char *)PS, MAXPROC_CHAR*sizeof(char)); min_number_of_en_in_PS=number_of_en_in_PS; if (min_number_of_en_in_PS == 0) break; }; };
#endif
number_of_succ_trans=0; for(i=1;i<=VS_nproc;i++) { if (bis_set(selected_proc,i) && bis_set(enabled_proc,i) && !bis_set(sleep_set,i)) { int_ptr=VS_shm+(4*i); branching = (*int_ptr==TOSS) ? *(int_ptr+1) : 0;
#ifndef SIMUL
if (branching >= 24) { fprintf(stderr, "VeriSoft Error: argument to VS_toss() is %d\nand should be less than 24 instead!\n",branching); VS_produce_error_path(); VS_wrapup(); return; } if ((Seed != 1) && (branching != 0)) memset((char *)seed_proc, 0, MAXPROC_CHAR*sizeof(char)); for (m=0;m<=branching;m++) { if ((Seed == 1) || (branching == 0)) k=m; else { if (m < branching) k=VS_Rand() % (branching-m+1); else k=0; j=-1; while(k>=0) { j++; if (!bis_set(seed_proc,j)) k--; }; k=j; bset(seed_proc,j); };
#else
for (k=0;k<=branching;k++) {
#endif
(trans_stack+number_of_trans)->label=number_of_trans; (trans_stack+number_of_trans)->process_id=i; (trans_stack+number_of_trans)->toss_choice=k; (trans_stack+number_of_trans)->previous_trans=(dfs_stpt) ? (dfs_stack+dfs_stpt-1)->trans : -1; number_of_succ_trans++; if (number_of_succ_trans==1) (state_stack+number_of_states)->first_next_trans=number_of_trans; number_of_trans++; if (number_of_trans==trans_stack_size) { j=trans_stack_size+BASIC_SIZE; trans_stack=(struct Trans *)VS_erealloc((char *)trans_stack, j*sizeof(struct Trans), trans_stack_size*sizeof(struct Trans)); trans_stack_size=j; }; }; }; };
#ifdef SIMUL
printf("\nEnabled transitions:\n"); for(i=1;i<=number_of_succ_trans;i++) { printf("\tchoice %d -- Process_%d: ", i, (trans_stack+number_of_trans-number_of_succ_trans-1+i)->process_id); printf("\n"); }; printf("\t(choice 0 to restart simulation)\n"); reask: printf("\nNext transition? "); scanf("%d", &i); if ((i<0) || (i>number_of_succ_trans)) { printf("\ninvalid choice"); goto reask; }; if (i==0) { VS_clean_system(); dfs_stpt=0; goto Backtrack; }; printf("Next transition is "); fo=stdout; pid=(trans_stack+number_of_trans-number_of_succ_trans-1+i)->process_id; VS_print_next_sys_call(pid,number_of_trans-number_of_succ_trans-1+i); type_of_sys_call=*(VS_shm+(4*pid)); execute_trans(number_of_trans-number_of_succ_trans-1+i); VS_print_msg_of_previous_sys_call(type_of_sys_call); printf("\n"); goto Down;
#endif
Continue_search_after_error: (state_stack+number_of_states)->number_of_succ=number_of_succ_trans; number_of_states++; if (number_of_states==state_stack_size) { j=state_stack_size+BASIC_SIZE; state_stack=(struct State *)VS_erealloc((char*)state_stack, j*sizeof(struct State), state_stack_size*sizeof(struct State)); state_stack_size=j; };
#ifndef SIMUL
if ((VS_stop_at_state > 0) && (number_of_states>=VS_stop_at_state)) { printf("\nSearch completed with stop_at_state %d\n", VS_stop_at_state); VS_wrapup(); };
#endif
if (number_of_states>=report_state_limit) { printf("intermediate report: %d states visited so far\n", number_of_states); report_state_limit+=REPORT_STATE_UNIT; }; for(i=1;i<=VS_nproc;i++) { if ((last_enabled[i-1]!=-1) && ((dfs_stpt-last_enabled[i-1])>VS_livelock_limit)) { printf("\nlivelock of Process_%d detected at depth %d !!!\n", i, dfs_stpt); VS_produce_error_path(); }; }; if (number_of_succ_trans==0) goto Up; if (dfs_stpt==max_depth) {
#ifdef RANDOM_MEMORY_LESS_SEARCH
goto Up;
#endif
*(leaf_stack+leaf_stpt)=number_of_states-1; k=leaf_stpt*VS_nproc; if ((k+VS_nproc)>last_enabled_stack_size) { j=last_enabled_stack_size+BASIC_SIZE; last_enabled_stack=(int *)VS_erealloc((char *)last_enabled_stack, j*sizeof(int), last_enabled_stack_size*sizeof(int)); last_enabled_stack_size=j; }; for(i=1;i<=VS_nproc;i++) *(last_enabled_stack+k+i-1)=last_enabled[i-1]; leaf_stpt++; if (leaf_stpt==leaf_stack_size) { j=leaf_stack_size+BASIC_SIZE; leaf_stack=(int *)VS_erealloc((char *)leaf_stack, j*sizeof(int), leaf_stack_size*sizeof(int)); leaf_stack_size=j; }; Up: dfs_stpt--; while (((dfs_stack+dfs_stpt)->remaining==0) && (dfs_stpt>=min_depth)) dfs_stpt--; if (dfs_stpt<min_depth) { if (previous_leaf_stpt == 0) { if (max_depth == VS_max_depth) { printf("\nSearch completed with depth %d\n", VS_max_depth); VS_wrapup(); } else { min_depth=max_depth; max_depth+=VS_depth_incr; if (max_depth > VS_max_depth) max_depth=VS_max_depth; printf("intermediate report: depth is set from %d to %d, current breadth is %d\n", min_depth, max_depth, leaf_stpt);
#ifdef SS
fprintf(fo_ss, "#layer\n"); fflush(fo_ss);
#endif
int_ptr=previous_leaf_stack; previous_leaf_stack=leaf_stack; leaf_stack=int_ptr; int_ptr=previous_last_enabled_stack; previous_last_enabled_stack=last_enabled_stack; last_enabled_stack=int_ptr; previous_leaf_stpt=leaf_stpt; leaf_stpt=0; }; }; if (previous_leaf_stpt == 0) { printf("Search completed with depth %d\n", VS_max_depth); VS_wrapup(); } else { previous_leaf_stpt--; k=previous_leaf_stpt*VS_nproc; for(i=1;i<=VS_nproc;i++) last_enabled[i-1]=*(previous_last_enabled_stack+k+i-1); if (min_depth>temp_stack_size) { j=temp_stack_size+BASIC_SIZE; temp_stack=(int *)VS_erealloc((char *)temp_stack, j*sizeof(int), temp_stack_size*sizeof(int)); temp_stack_size=j; }; *(temp_stack)=(state_stack+*(previous_leaf_stack+previous_leaf_stpt))->first_next_trans; for(temp_stpt=1;temp_stpt<=min_depth;temp_stpt++) *(temp_stack+temp_stpt)=(trans_stack+(*(temp_stack+temp_stpt-1)))->previous_trans; dfs_stpt=0; while (temp_stpt) { temp_stpt--; (dfs_stack+dfs_stpt)->trans=*(temp_stack+temp_stpt); (dfs_stack+dfs_stpt)->remaining=0; dfs_stpt++; if (dfs_stpt==dfs_stack_size) { j=dfs_stack_size+BASIC_SIZE; dfs_stack=(struct El_dfs_stack *)VS_erealloc((char *)dfs_stack, j*sizeof(struct El_dfs_stack), dfs_stack_size*sizeof(struct El_dfs_stack)); dfs_stack_size=j; }; }; (dfs_stack+dfs_stpt-1)->remaining= ((state_stack+*(previous_leaf_stack+previous_leaf_stpt))->number_of_succ)-1; VS_clean_system(); goto Backtrack; }; } else {
#ifdef RANDOM_MEMORY_LESS_SEARCH
fclose(fo_sss); VS_evaluate_fitness(); if (!(fo_sss=fopen("sss.VS","w"))) { fprintf(stderr,"VeriSoft Error: cannot create sss.VS\n"); VS_wrapup(); } size_of_sss=0; i=VS_external_next_trans((state_stack)->number_of_succ); if (i == 0) { fprintf(stderr,"VeriSoft Error: no backtracking due to 'VS_external_next_trans' allowed here!\n"); VS_wrapup(); } (dfs_stack+dfs_stpt)->trans=((state_stack)->first_next_trans)+i-1; (dfs_stack+dfs_stpt)->remaining=1;
#else
(dfs_stack+dfs_stpt)->trans+=1; (dfs_stack+dfs_stpt)->remaining-=1;
#endif
dfs_stpt++; VS_clean_system(); goto Backtrack; } } else {
#ifdef RANDOM_MEMORY_LESS_SEARCH
i=VS_external_next_trans(number_of_succ_trans); if (i == -1) VS_produce_error_path(); if ((i == 0) || (i == -1)) { goto Up; } (dfs_stack+dfs_stpt)->trans=((state_stack+number_of_states-1)->first_next_trans)+i-1; if (dfs_stpt == min_depth) (dfs_stack+dfs_stpt)->remaining=1; else (dfs_stack+dfs_stpt)->remaining=0;
#else
(dfs_stack+dfs_stpt)->trans=(state_stack+number_of_states-1)->first_next_trans; (dfs_stack+dfs_stpt)->remaining=((state_stack+number_of_states-1)->number_of_succ)-1;
#endif
dfs_stpt++; if (dfs_stpt==dfs_stack_size) { j=dfs_stack_size+BASIC_SIZE; dfs_stack=(struct El_dfs_stack *)VS_erealloc((char *)dfs_stack, j*sizeof(struct El_dfs_stack), dfs_stack_size*sizeof(struct El_dfs_stack)); dfs_stack_size=j; }; update_sleep_sets((dfs_stack+dfs_stpt-1)->trans, number_of_states-1, number_of_states);
#ifndef SIMUL
if (VS_save_state_space) VS_print_trans_in_sss_pre((dfs_stack+dfs_stpt-1)->trans);
#endif
#ifdef EDV
temp_trans=(dfs_stack+dfs_stpt-1)->trans; fprintf(fo_sss,"%d\t%d\t%d\t%d\t%d\t", ((trans_stack+temp_trans)->previous_trans == -1) ? 0 : (trans_stack+((trans_stack+temp_trans)->previous_trans))->successor_state, number_of_states, (trans_stack+temp_trans)->label, (trans_stack+temp_trans)->process_id, (trans_stack+temp_trans)->toss_choice); fo=fo_sss; pid=(trans_stack+temp_trans)->process_id; VS_print_next_sys_call(pid,temp_trans); type_of_sys_call=*(VS_shm+(4*pid));
#endif
#ifdef SS
temp_trans=(dfs_stack+dfs_stpt-1)->trans; fprintf(fo_ss,"%d\t%d\t%d\t", ((trans_stack+temp_trans)->previous_trans == -1) ? 0 : (trans_stack+((trans_stack+temp_trans)->previous_trans))->successor_state, number_of_states, (trans_stack+temp_trans)->process_id); fo=fo_ss; pid=(trans_stack+temp_trans)->process_id; VS_print_next_sys_call(pid,temp_trans); type_of_sys_call=*(VS_shm+(4*pid));
#endif
#ifndef SIMUL
alarm(VS_divergence_limit);
#endif
execute_trans((dfs_stack+dfs_stpt-1)->trans); (trans_stack+((dfs_stack+dfs_stpt-1)->trans))->successor_state=number_of_states;
#ifndef SIMUL
if (VS_save_state_space) VS_print_trans_in_sss_post();
#endif
#ifdef EDV
VS_print_msg_of_previous_sys_call(type_of_sys_call); fprintf(fo_sss,"\n");
#endif
#ifdef SS
VS_print_msg_of_previous_sys_call(type_of_sys_call); fprintf(fo_ss,"\n");
#endif
goto Down; } }